/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableShortShortMapFactory;
import com.gs.collections.api.map.primitive.ImmutableShortShortMap;
import com.gs.collections.api.map.primitive.ShortShortMap;

/**
 * ImmutableShortShortMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableShortShortMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableShortShortMapFactoryImpl implements ImmutableShortShortMapFactory
{
    public ImmutableShortShortMap of()
    {
        return this.with();
    }

    public ImmutableShortShortMap with()
    {
        return ImmutableShortShortEmptyMap.INSTANCE;
    }

    public ImmutableShortShortMap of(short key, short value)
    {
        return this.with(key, value);
    }

    public ImmutableShortShortMap with(short key, short value)
    {
        return new ImmutableShortShortSingletonMap(key, value);
    }

    public ImmutableShortShortMap ofAll(ShortShortMap map)
    {
        return this.withAll(map);
    }

    public ImmutableShortShortMap withAll(ShortShortMap map)
    {
        if (map instanceof ImmutableShortShortMap)
        {
            return (ImmutableShortShortMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            short key = map.keysView().shortIterator().next();
            return new ImmutableShortShortSingletonMap(key, map.get(key));
        }
        return new ImmutableShortShortHashMap(map);
    }
}
