/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableCharSetFactory;
import com.gs.collections.api.set.primitive.ImmutableCharSet;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;

/**
 * ImmutableCharSetFactoryImpl is a factory implementation which creates instances of type {@link ImmutableCharSet}.
 * This file was automatically generated from template file immutablePrimitiveSetFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableCharSetFactoryImpl implements ImmutableCharSetFactory
{
    public ImmutableCharSet of()
    {
        return this.with();
    }

    public ImmutableCharSet with()
    {
        return ImmutableCharEmptySet.INSTANCE;
    }

    public ImmutableCharSet of(char one)
    {
        return this.with(one);
    }

    public ImmutableCharSet with(char one)
    {
        return new ImmutableCharSingletonSet(one);
    }

    public ImmutableCharSet of(char... items)
    {
        return this.with(items);
    }

    public ImmutableCharSet with(char... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return CharHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableCharSet ofAll(CharIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableCharSet withAll(CharIterable items)
    {
        if (items instanceof ImmutableCharSet)
        {
            return (ImmutableCharSet) items;
        }
        return this.with(items.toArray());
    }
}
