/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.ImmutableShortSet;
import com.gs.collections.api.set.primitive.ShortSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import com.gs.collections.impl.factory.primitive.ShortSets;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import net.jcip.annotations.Immutable;

/**
 * ImmutableShortSingletonSet is an optimization for {@link ImmutableShortSet} of size 1.
 * This file was automatically generated from template file immutablePrimitiveSingletonSet.stg.
 *
 * @since 4.0.
 */
@Immutable
final class ImmutableShortSingletonSet implements ImmutableShortSet, Serializable
{
    private static final long serialVersionUID = 1L;

    private final short element;

    ImmutableShortSingletonSet (short element)
    {
        this.element = element;
    }

    public ImmutableShortSet newWith(short element)
    {
        return ShortSets.immutable.with(this.element, element);
    }

    public ImmutableShortSet newWithout(short element)
    {
        return this.element == element ? ShortSets.immutable.with() : this;
    }

    public ImmutableShortSet newWithAll(ShortIterable elements)
    {
        return ShortHashSet.newSet(elements).with(this.element).toImmutable();
    }

    public ImmutableShortSet newWithoutAll(ShortIterable elements)
    {
        return elements.contains(this.element) ? ShortSets.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public boolean contains(short value)
    {
        return this.element == value;
    }

    public boolean containsAll(ShortIterable source)
    {
        for (ShortIterator iterator = source.shortIterator(); iterator.hasNext(); )
        {
            if (this.element != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(short... source)
    {
        for (short value : source)
        {
            if (this.element != value)
            {
                return false;
            }
        }
        return true;
    }

    public void forEach(ShortProcedure procedure)
    {
        procedure.value(this.element);
    }

    public ImmutableShortSet select(ShortPredicate predicate)
    {
        return predicate.accept(this.element) ? ShortHashSet.newSetWith(this.element).toImmutable()
                : new ShortHashSet().toImmutable();
    }

    public ImmutableShortSet reject(ShortPredicate predicate)
    {
        return predicate.accept(this.element) ? new ShortHashSet().toImmutable()
                : ShortHashSet.newSetWith(this.element).toImmutable();
    }

    public <V> ImmutableSet<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return UnifiedSet.<V>newSetWith(function.valueOf(this.element)).toImmutable();
    }

    public MutableShortList toList()
    {
        return ShortArrayList.newListWith(this.element);
    }

    public int sizeDistinct()
    {
        return 1;
    }

    public int occurrencesOf(short item)
    {
        return this.element == item ? 1 : 0;
    }

    public void forEachWithOccurrences(ShortIntProcedure shortIntProcedure)
    {
        shortIntProcedure.value(this.element, 1);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    public int count(ShortPredicate predicate)
    {
        return predicate.accept(this.element) ? 1 : 0;
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return predicate.accept(this.element);
    }

    public long sum()
    {
        return this.element;
    }

    public short min()
    {
        return this.element;
    }

    public short max()
    {
        return this.element;
    }

    public short maxIfEmpty(short defaultValue)
    {
        return this.element;
    }

    public short minIfEmpty(short defaultValue)
    {
        return this.element;
    }

    public double average()
    {
        return this.element;
    }

    public double median()
    {
        return this.element;
    }

    public short[] toSortedArray()
    {
        return new short[]{this.element};
    }

    public MutableShortList toSortedList()
    {
        return ShortArrayList.newListWith(this.element);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return !predicate.accept(this.element);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return predicate.accept(this.element);
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ShortSet))
        {
            return false;
        }
        ShortSet set = (ShortSet) obj;
        if (set.size() != 1)
        {
            return false;
        }
        return set.contains(this.element);
    }

    @Override
    public int hashCode()
    {
        return (int) this.element ^ 1;
    }

    public MutableShortSet toSet()
    {
        return ShortHashSet.newSetWith(this.element);
    }

    public MutableShortBag toBag()
    {
        return ShortHashBag.newBagWith(this.element);
    }

    public ShortSet freeze()
    {
        return this;
    }

    public ImmutableShortSet toImmutable()
    {
        return this;
    }

    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    public short[] toArray()
    {
        return new short[]{this.element};
    }

    @Override
    public String toString()
    {
        return '[' + this.makeString() + ']';
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public ShortIterator shortIterator()
    {
        return ShortHashSet.newSetWith(this.element).shortIterator();
    }
}

