/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableByteSet;
import com.gs.collections.api.set.primitive.ByteSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableByteCollection;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveSet.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableByteSet
        extends AbstractUnmodifiableByteCollection
        implements MutableByteSet
{
    private static final long serialVersionUID = 1L;

    UnmodifiableByteSet(MutableByteSet set)
    {
        super(set);
    }

    /**
     * This method will take a MutableByteSet and wrap it directly in a UnmodifiableByteSet.
     */
    public static UnmodifiableByteSet of(MutableByteSet set)
    {
        if (set == null)
        {
            throw new IllegalArgumentException("cannot create an UnmodifiableByteSet for null");
        }
        return new UnmodifiableByteSet(set);
    }

    private MutableByteSet getMutableByteSet()
    {
        return (MutableByteSet) this.getByteCollection();
    }

    @Override
    public UnmodifiableByteSet with(byte element)
    {
        throw new UnsupportedOperationException("Cannot call with on an UnmodifiableByteSet");
    }

    @Override
    public UnmodifiableByteSet without(byte element)
    {
        throw new UnsupportedOperationException("Cannot call without on an UnmodifiableByteSet");
    }

    @Override
    public UnmodifiableByteSet withAll(ByteIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll on an UnmodifiableByteSet");
    }

    @Override
    public UnmodifiableByteSet withoutAll(ByteIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll on an UnmodifiableByteSet");
    }

    @Override
    public MutableByteSet select(BytePredicate predicate)
    {
        return this.getMutableByteSet().select(predicate);
    }

    @Override
    public MutableByteSet reject(BytePredicate predicate)
    {
        return this.getMutableByteSet().reject(predicate);
    }

    @Override
    public <V> MutableSet<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return this.getMutableByteSet().collect(function);
    }

    @Override
    public boolean equals(Object otherSet)
    {
        return this.getMutableByteSet().equals(otherSet);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableByteSet().hashCode();
    }

    @Override
    public LazyByteIterable asLazy()
    {
        return new LazyByteIterableAdapter(this);
    }

    @Override
    public MutableByteSet asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableByteSet asSynchronized()
    {
        return new SynchronizedByteSet(this);
    }

    public ByteSet freeze()
    {
        return this.getMutableByteSet().freeze();
    }

    @Override
    public ImmutableByteSet toImmutable()
    {
        return this.getMutableByteSet().toImmutable();
    }
}
