/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableLongSet;
import com.gs.collections.api.set.primitive.LongSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableLongCollection;
import com.gs.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveSet.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableLongSet
        extends AbstractUnmodifiableLongCollection
        implements MutableLongSet
{
    private static final long serialVersionUID = 1L;

    UnmodifiableLongSet(MutableLongSet set)
    {
        super(set);
    }

    /**
     * This method will take a MutableLongSet and wrap it directly in a UnmodifiableLongSet.
     */
    public static UnmodifiableLongSet of(MutableLongSet set)
    {
        if (set == null)
        {
            throw new IllegalArgumentException("cannot create an UnmodifiableLongSet for null");
        }
        return new UnmodifiableLongSet(set);
    }

    private MutableLongSet getMutableLongSet()
    {
        return (MutableLongSet) this.getLongCollection();
    }

    @Override
    public UnmodifiableLongSet with(long element)
    {
        throw new UnsupportedOperationException("Cannot call with on an UnmodifiableLongSet");
    }

    @Override
    public UnmodifiableLongSet without(long element)
    {
        throw new UnsupportedOperationException("Cannot call without on an UnmodifiableLongSet");
    }

    @Override
    public UnmodifiableLongSet withAll(LongIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll on an UnmodifiableLongSet");
    }

    @Override
    public UnmodifiableLongSet withoutAll(LongIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll on an UnmodifiableLongSet");
    }

    @Override
    public MutableLongSet select(LongPredicate predicate)
    {
        return this.getMutableLongSet().select(predicate);
    }

    @Override
    public MutableLongSet reject(LongPredicate predicate)
    {
        return this.getMutableLongSet().reject(predicate);
    }

    @Override
    public <V> MutableSet<V> collect(LongToObjectFunction<? extends V> function)
    {
        return this.getMutableLongSet().collect(function);
    }

    @Override
    public boolean equals(Object otherSet)
    {
        return this.getMutableLongSet().equals(otherSet);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableLongSet().hashCode();
    }

    @Override
    public LazyLongIterable asLazy()
    {
        return new LazyLongIterableAdapter(this);
    }

    @Override
    public MutableLongSet asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableLongSet asSynchronized()
    {
        return new SynchronizedLongSet(this);
    }

    public LongSet freeze()
    {
        return this.getMutableLongSet().freeze();
    }

    @Override
    public ImmutableLongSet toImmutable()
    {
        return this.getMutableLongSet().toImmutable();
    }
}
