/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableByteStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableByteStack;

/**
 * ImmutableByteStackFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableByteStackFactoryImpl implements ImmutableByteStackFactory
{
    public ImmutableByteStack of()
    {
        return this.with();
    }

    public ImmutableByteStack with()
    {
        return ImmutableByteEmptyStack.INSTANCE;
    }

    public ImmutableByteStack of(byte one)
    {
        return this.with(one);
    }

    public ImmutableByteStack with(byte one)
    {
        return new ImmutableByteSingletonStack(one);
    }

    public ImmutableByteStack of(byte... items)
    {
        return this.with(items);
    }

    public ImmutableByteStack with(byte... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableByteArrayStack.newStackWith(items);
    }

    public ImmutableByteStack ofAll(ByteIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableByteStack withAll(ByteIterable items)
    {
        if (items instanceof ImmutableByteStack)
        {
            return (ImmutableByteStack) items;
        }
        return this.with(items.toArray());
    }

    public ImmutableByteStack ofAllReversed(ByteIterable items)
    {
        return this.withAllReversed(items);
    }

    public ImmutableByteStack withAllReversed(ByteIterable items)
    {
        if (items == null || items.isEmpty())
        {
            return this.with();
        }
        if (items.size() == 1)
        {
            return this.with(items.toArray());
        }
        return ImmutableByteArrayStack.newStackFromTopToBottom(items);
    }
}
