/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableDoubleStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableDoubleStack;

/**
 * ImmutableDoubleStackFactoryImpl is a factory implementation which creates instances of type {@link ImmutableDoubleStack}.
 * This file was automatically generated from template file immutablePrimitiveStackFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableDoubleStackFactoryImpl implements ImmutableDoubleStackFactory
{
    public ImmutableDoubleStack of()
    {
        return this.with();
    }

    public ImmutableDoubleStack with()
    {
        return ImmutableDoubleEmptyStack.INSTANCE;
    }

    public ImmutableDoubleStack of(double one)
    {
        return this.with(one);
    }

    public ImmutableDoubleStack with(double one)
    {
        return new ImmutableDoubleSingletonStack(one);
    }

    public ImmutableDoubleStack of(double... items)
    {
        return this.with(items);
    }

    public ImmutableDoubleStack with(double... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableDoubleArrayStack.newStackWith(items);
    }

    public ImmutableDoubleStack ofAll(DoubleIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableDoubleStack withAll(DoubleIterable items)
    {
        if (items instanceof ImmutableDoubleStack)
        {
            return (ImmutableDoubleStack) items;
        }
        return this.with(items.toArray());
    }

    public ImmutableDoubleStack ofAllReversed(DoubleIterable items)
    {
        return this.withAllReversed(items);
    }

    public ImmutableDoubleStack withAllReversed(DoubleIterable items)
    {
        if (items == null || items.isEmpty())
        {
            return this.with();
        }
        if (items.size() == 1)
        {
            return this.with(items.toArray());
        }
        return ImmutableDoubleArrayStack.newStackFromTopToBottom(items);
    }
}
