/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.ImmutableIntBag;
import com.gs.collections.api.bag.primitive.IntBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntIntProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableIntSingletonBag;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.primitive.IntBags;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableIntEmptyBag
implements ImmutableIntBag,
Serializable {
    private static final long serialVersionUID = 1L;
    static final ImmutableIntBag INSTANCE = new ImmutableIntEmptyBag();

    ImmutableIntEmptyBag() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ImmutableIntBag newWith(int element) {
        return new ImmutableIntSingletonBag(element);
    }

    public ImmutableIntBag newWithout(int element) {
        return this;
    }

    public ImmutableIntBag newWithAll(IntIterable elements) {
        return IntBags.immutable.withAll(elements);
    }

    public ImmutableIntBag newWithoutAll(IntIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean contains(int value) {
        return false;
    }

    public boolean containsAll(IntIterable source) {
        return source.isEmpty();
    }

    public boolean containsAll(int ... elements) {
        return elements.length == 0;
    }

    public void forEach(IntProcedure procedure) {
    }

    public ImmutableIntBag select(IntPredicate predicate) {
        return this;
    }

    public ImmutableIntBag reject(IntPredicate predicate) {
        return this;
    }

    public <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        return Bags.immutable.of();
    }

    public MutableIntList toList() {
        return new IntArrayList();
    }

    public int sizeDistinct() {
        return 0;
    }

    public int occurrencesOf(int item) {
        return 0;
    }

    public void forEachWithOccurrences(IntIntProcedure intIntProcedure) {
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return ifNone;
    }

    public int count(IntPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return false;
    }

    public long sum() {
        return 0L;
    }

    public int min() {
        throw new NoSuchElementException();
    }

    public int max() {
        throw new NoSuchElementException();
    }

    public int maxIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public int minIfEmpty(int defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public int[] toSortedArray() {
        return new int[0];
    }

    public MutableIntList toSortedList() {
        return new IntArrayList();
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return true;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntBag)) {
            return false;
        }
        IntBag bag = (IntBag)obj;
        return bag.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public MutableIntSet toSet() {
        return new IntHashSet();
    }

    public MutableIntBag toBag() {
        return new IntHashBag();
    }

    public ImmutableIntBag toImmutable() {
        return this;
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public int[] toArray() {
        return new int[0];
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IntIterator intIterator() {
        return new InternalIntIterator();
    }

    private static class InternalIntIterator
    implements IntIterator {
        private InternalIntIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public int next() {
            throw new NoSuchElementException();
        }
    }
}

