/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.collection.mutable;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.Function3;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.PartitionMutableCollection;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.api.tuple.Twin;
import com.gs.collections.impl.block.factory.Comparators;
import com.gs.collections.impl.block.procedure.MutatingAggregationProcedure;
import com.gs.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import com.gs.collections.impl.collection.mutable.CollectionAdapter;
import com.gs.collections.impl.collection.mutable.UnmodifiableMutableCollection;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.set.sorted.mutable.TreeSortedSet;
import com.gs.collections.impl.utility.LazyIterate;
import com.gs.collections.impl.utility.internal.IterableIterate;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class SynchronizedMutableCollection<T>
implements MutableCollection<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    @GuardedBy(value="this.lock")
    private final MutableCollection<T> collection;

    protected SynchronizedMutableCollection(MutableCollection<T> newCollection) {
        this(newCollection, null);
    }

    protected SynchronizedMutableCollection(MutableCollection<T> newCollection, Object newLock) {
        if (newCollection == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedMutableCollection on a null collection");
        }
        this.collection = newCollection;
        this.lock = newLock == null ? this : newLock;
    }

    public static <E, C extends Collection<E>> SynchronizedMutableCollection<E> of(C collection) {
        return new SynchronizedMutableCollection(CollectionAdapter.adapt(collection));
    }

    public static <E, C extends Collection<E>> SynchronizedMutableCollection<E> of(C collection, Object lock) {
        return new SynchronizedMutableCollection(CollectionAdapter.adapt(collection), lock);
    }

    protected Object getLock() {
        return this.lock;
    }

    protected MutableCollection<T> getCollection() {
        return this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] toArray(T[] a) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toArray((Object[])a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toString();
        }
    }

    public Iterator<T> iterator() {
        return this.collection.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T o) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection<?> coll) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAllIterable(Iterable<?> source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAllIterable(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAllArguments(Object ... elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAllArguments(elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection<? extends T> coll) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.addAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection<?> coll) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection<?> coll) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.retainAll(coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.collection.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(Procedure<? super T> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.forEachWith(procedure, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.forEachWithIndex(objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.allSatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.noneSatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.anySatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toMap(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSortedMap(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super T, ? extends NK> keyFunction, Function<? super T, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSortedMap(comparator, keyFunction, valueFunction);
        }
    }

    public LazyIterable<T> asLazy() {
        return LazyIterate.adapt(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<T> toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<T> toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<T> toSortedList(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSortedList(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Comparable<? super V>> MutableList<T> toSortedListBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSortedList(Comparators.byFunction(function));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<T> toSortedSet() {
        Object object = this.lock;
        synchronized (object) {
            return TreeSortedSet.newSet(null, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<T> toSortedSet(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return TreeSortedSet.newSet(comparator, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Comparable<? super V>> MutableSortedSet<T> toSortedSetBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.toSortedSet((Comparator<? super T>)Comparators.byFunction(function));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<T> asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return new UnmodifiableMutableCollection(this);
        }
    }

    public MutableCollection<T> asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableCollection<T> toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableCollection<V> collect(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanCollection collectBoolean(BooleanFunction<? super T> booleanFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collectBoolean(booleanFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteCollection collectByte(ByteFunction<? super T> byteFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collectByte(byteFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharCollection collectChar(CharFunction<? super T> charFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collectChar(charFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleCollection collectDouble(DoubleFunction<? super T> doubleFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collectDouble(doubleFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatCollection collectFloat(FloatFunction<? super T> floatFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collectFloat(floatFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntCollection collectInt(IntFunction<? super T> intFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collectInt(intFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongCollection collectLong(LongFunction<? super T> longFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collectLong(longFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortCollection collectShort(ShortFunction<? super T> shortFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collectShort(shortFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.collection.collect(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableCollection<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.flatCollect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.collection.flatCollect(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableCollection<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collectIf(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.collection.collectIf(predicate, function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, A> MutableCollection<A> collectWith(Function2<? super T, ? super P, ? extends A> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collectWith(function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, A, R extends Collection<A>> R collectWith(Function2<? super T, ? super P, ? extends A> function, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.collection.collectWith(function, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.countWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T detect(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.detect(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T min(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.min(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T max(Comparator<? super T> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.max(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T min() {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T max() {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.minBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.maxBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.detectIfNone(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.detectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> T detectWithIfNone(Predicate2<? super T, ? super P> predicate, P parameter, Function0<? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.detectWithIfNone(predicate, parameter, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getFirst() {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getLast() {
        Object object = this.lock;
        synchronized (object) {
            return (T)this.collection.getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        Object object = this.lock;
        synchronized (object) {
            return (IV)this.collection.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumOfInt(IntFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.sumOfInt(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sumOfFloat(FloatFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.sumOfFloat(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumOfLong(LongFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.sumOfLong(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sumOfDouble(DoubleFunction<? super T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.sumOfDouble(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IV, P> IV injectIntoWith(IV injectValue, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return (IV)this.collection.injectIntoWith(injectValue, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<T> newEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.newEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<T> reject(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.collection.reject(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableCollection<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.rejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.collection.rejectWith(predicate, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIf(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.removeIf(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> void removeIfWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.removeIfWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<T> select(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.collection.select(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> Twin<MutableList<T>> selectAndRejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.selectAndRejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionMutableCollection<T> partition(Predicate<? super T> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.partition(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableCollection<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.selectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.collection.selectWith(predicate, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> MutableCollection<S> selectInstancesOf(Class<S> clazz) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.selectInstancesOf(clazz);
        }
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            IterableIterate.appendString(this, appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.groupBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.groupByEach(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends MutableMultimap<V, T>> R groupBy(Function<? super T, ? extends V> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.collection.groupBy(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V, R extends MutableMultimap<V, T>> R groupByEach(Function<? super T, ? extends Iterable<V>> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.collection.groupByEach(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> MutableCollection<Pair<T, S>> zip(Iterable<S> that) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.zip(that);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.collection.zip(that, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCollection<Pair<T, Integer>> zipWithIndex() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.zipWithIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.collection.zipWithIndex(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichIterable<RichIterable<T>> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.chunk(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAllIterable(Iterable<? extends T> iterable) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.addAllIterable(iterable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAllIterable(Iterable<?> iterable) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeAllIterable(iterable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAllIterable(Iterable<?> iterable) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.retainAllIterable(iterable);
        }
    }

    public MutableCollection<T> with(T element) {
        this.add(element);
        return this;
    }

    public MutableCollection<T> without(T element) {
        this.remove(element);
        return this;
    }

    public MutableCollection<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    public MutableCollection<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    public <K, V> MutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map;
    }

    public <K, V> MutableMap<K, V> aggregateBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map;
    }
}

