/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.collection.mutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import java.io.Serializable;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class AbstractSynchronizedBooleanCollection
implements MutableBooleanCollection,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    @GuardedBy(value="this.lock")
    private final MutableBooleanCollection collection;

    protected AbstractSynchronizedBooleanCollection(MutableBooleanCollection collection) {
        this(collection, null);
    }

    protected AbstractSynchronizedBooleanCollection(MutableBooleanCollection collection, Object newLock) {
        this.collection = collection;
        this.lock = newLock == null ? this : newLock;
    }

    protected Object getLock() {
        return this.lock;
    }

    protected MutableBooleanCollection getBooleanCollection() {
        return this.collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.collection.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanCollection select(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanCollection reject(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanCollection with(boolean element) {
        Object object = this.lock;
        synchronized (object) {
            this.add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanCollection without(boolean element) {
        Object object = this.lock;
        synchronized (object) {
            this.remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanCollection withAll(BooleanIterable elements) {
        Object object = this.lock;
        synchronized (object) {
            this.addAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanCollection withoutAll(BooleanIterable elements) {
        Object object = this.lock;
        synchronized (object) {
            this.removeAll(elements);
        }
        return this;
    }

    public MutableBooleanCollection asUnmodifiable() {
        return new UnmodifiableBooleanCollection(this);
    }

    public MutableBooleanCollection asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableBooleanCollection toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toImmutable();
        }
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(boolean ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(BooleanIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(boolean newItem) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.add(newItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(boolean ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.addAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(BooleanIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.addAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(boolean value) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.remove(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(BooleanIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(boolean ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.removeAll(source);
        }
    }

    public BooleanIterator booleanIterator() {
        return this.collection.booleanIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(BooleanProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(BooleanPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.collection.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.collection.toBag();
        }
    }
}

