/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.block.factory.primitive.ShortPredicates;
import com.gs.collections.impl.lazy.primitive.CollectShortToObjectIterable;
import com.gs.collections.impl.lazy.primitive.SelectShortIterable;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class CollectShortIterable<T>
implements LazyShortIterable {
    private final LazyIterable<T> iterable;
    private final ShortFunction<? super T> function;
    private final ShortFunctionToProcedure shortFunctionToProcedure = new ShortFunctionToProcedure();

    public CollectShortIterable(LazyIterable<T> adapted, ShortFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
    }

    public ShortIterator shortIterator() {
        return new ShortIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectShortIterable.this.iterable.iterator();
            }

            public short next() {
                return CollectShortIterable.this.function.shortValueOf(this.iterator.next());
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    public void forEach(ShortProcedure procedure) {
        this.iterable.forEachWith((Procedure2)this.shortFunctionToProcedure, (Object)procedure);
    }

    public int size() {
        return this.iterable.size();
    }

    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    public int count(final ShortPredicate predicate) {
        return this.iterable.count(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectShortIterable.this.function.shortValueOf(each));
            }
        });
    }

    public boolean anySatisfy(final ShortPredicate predicate) {
        return this.iterable.anySatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectShortIterable.this.function.shortValueOf(each));
            }
        });
    }

    public boolean allSatisfy(final ShortPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return predicate.accept(CollectShortIterable.this.function.shortValueOf(each));
            }
        });
    }

    public boolean noneSatisfy(final ShortPredicate predicate) {
        return this.iterable.allSatisfy(new Predicate<T>(){

            public boolean accept(T each) {
                return !predicate.accept(CollectShortIterable.this.function.shortValueOf(each));
            }
        });
    }

    public LazyShortIterable select(ShortPredicate predicate) {
        return new SelectShortIterable((ShortIterable)this, predicate);
    }

    public LazyShortIterable reject(ShortPredicate predicate) {
        return new SelectShortIterable((ShortIterable)this, ShortPredicates.not(predicate));
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        ShortIterator iterator = this.shortIterator();
        while (iterator.hasNext()) {
            short next = iterator.next();
            if (!predicate.accept(next)) continue;
            return next;
        }
        return ifNone;
    }

    public <V> LazyIterable<V> collect(ShortToObjectFunction<? extends V> function) {
        return new CollectShortToObjectIterable<V>((ShortIterable)this, function);
    }

    public long sum() {
        return this.iterable.injectInto(0L, new LongObjectToLongFunction<T>(){

            public long longValueOf(long longValue, T each) {
                return longValue + (long)CollectShortIterable.this.function.shortValueOf(each);
            }
        });
    }

    public short max() {
        ShortIterator iterator = this.shortIterator();
        short max = iterator.next();
        while (iterator.hasNext()) {
            short next = iterator.next();
            max = next > max ? next : max;
        }
        return max;
    }

    public short min() {
        ShortIterator iterator = this.shortIterator();
        short min = iterator.next();
        while (iterator.hasNext()) {
            short next = iterator.next();
            min = min < next ? min : next;
        }
        return min;
    }

    public short minIfEmpty(short defaultValue) {
        try {
            return this.min();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public short maxIfEmpty(short defaultValue) {
        try {
            return this.max();
        }
        catch (NoSuchElementException noSuchElementException) {
            return defaultValue;
        }
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        short[] sortedArray = this.toSortedArray();
        int i = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[i];
            short second = sortedArray[i - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[i];
    }

    public short[] toArray() {
        final short[] array = new short[this.size()];
        this.iterable.forEachWithIndex(new ObjectIntProcedure<T>(){

            public void value(T each, int index) {
                array[index] = CollectShortIterable.this.function.shortValueOf(each);
            }
        });
        return array;
    }

    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            ShortIterator iterator = this.shortIterator();
            if (iterator.hasNext()) {
                appendable.append(String.valueOf(iterator.next()));
                while (iterator.hasNext()) {
                    appendable.append(separator);
                    appendable.append(String.valueOf(iterator.next()));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MutableShortList toList() {
        return ShortArrayList.newList((ShortIterable)this);
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newList((ShortIterable)this).sortThis();
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSet((ShortIterable)this);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBag((ShortIterable)this);
    }

    public LazyShortIterable asLazy() {
        return this;
    }

    public boolean contains(short value) {
        return this.anySatisfy(ShortPredicates.equal(value));
    }

    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ShortFunctionToProcedure
    implements Procedure2<T, ShortProcedure> {
        private static final long serialVersionUID = -4133872659735979655L;

        private ShortFunctionToProcedure() {
        }

        public void value(T each, ShortProcedure parm) {
            parm.value(CollectShortIterable.this.function.shortValueOf(each));
        }
    }
}

