/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharCharPredicate;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharCharProcedure;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.CharCharMap;
import com.gs.collections.api.map.primitive.ImmutableCharCharMap;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.CharCharMaps;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.map.mutable.primitive.CharCharHashMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableCharCharSingletonMap
implements ImmutableCharCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\u0000';
    private final char key1;
    private final char value1;

    ImmutableCharCharSingletonMap(char key1, char value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public char get(char key) {
        return this.getIfAbsent(key, '\u0000');
    }

    public char getIfAbsent(char key, char ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public char getOrThrow(char key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(char key) {
        return this.key1 == key;
    }

    public boolean containsValue(char value) {
        return this.value1 == value;
    }

    public void forEachValue(CharProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(CharProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(CharCharProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public LazyCharIterable keysView() {
        return CharCharHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableCharCharMap select(CharCharPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? CharCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new CharCharHashMap().toImmutable();
    }

    public ImmutableCharCharMap reject(CharCharPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new CharCharHashMap().toImmutable() : CharCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public ImmutableCharCharMap toImmutable() {
        return this;
    }

    public CharIterator charIterator() {
        return CharCharHashMap.newWithKeysValues(this.key1, this.value1).charIterator();
    }

    public void forEach(CharProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(CharPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public char min() {
        return this.value1;
    }

    public char max() {
        return this.value1;
    }

    public char maxIfEmpty(char defaultValue) {
        return this.value1;
    }

    public char minIfEmpty(char defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public char[] toSortedArray() {
        return new char[]{this.value1};
    }

    public MutableCharList toSortedList() {
        return CharArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(CharPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(CharPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(CharPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableCharCollection select(CharPredicate predicate) {
        return predicate.accept(this.value1) ? CharArrayList.newListWith(this.value1).toImmutable() : new CharArrayList().toImmutable();
    }

    public ImmutableCharCollection reject(CharPredicate predicate) {
        return predicate.accept(this.value1) ? new CharArrayList().toImmutable() : CharArrayList.newListWith(this.value1).toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function) {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public char[] toArray() {
        return new char[]{this.value1};
    }

    public boolean contains(char value) {
        return this.value1 == value;
    }

    public boolean containsAll(char ... source) {
        for (char value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(CharIterable source) {
        CharIterator iterator = source.charIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableCharList toList() {
        return CharArrayList.newListWith(this.value1);
    }

    public MutableCharSet toSet() {
        return CharHashSet.newSetWith(this.value1);
    }

    public MutableCharBag toBag() {
        return CharHashBag.newBagWith(this.value1);
    }

    public LazyCharIterable asLazy() {
        return new LazyCharIterableAdapter((CharIterable)this);
    }

    public ImmutableCharCharMap newWithKeyValue(char key, char value) {
        return CharCharMaps.immutable.withAll((CharCharMap)CharCharHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableCharCharMap newWithoutKey(char key) {
        return this.key1 == key ? CharCharMaps.immutable.with() : this;
    }

    public ImmutableCharCharMap newWithoutAllKeys(CharIterable keys) {
        return keys.contains(this.key1) ? CharCharMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableCharSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableCharCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CharCharMap)) {
            return false;
        }
        CharCharMap map = (CharCharMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

