/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.IntDoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.ImmutableIntDoubleMap;
import com.gs.collections.api.map.primitive.IntDoubleMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.map.immutable.primitive.ImmutableIntDoubleSingletonMap;
import com.gs.collections.impl.map.mutable.primitive.IntDoubleHashMap;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableIntDoubleEmptyMap
implements ImmutableIntDoubleMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_VALUE = 0.0;
    static final ImmutableIntDoubleMap INSTANCE = new ImmutableIntDoubleEmptyMap();

    ImmutableIntDoubleEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public double get(int key) {
        return 0.0;
    }

    public double getIfAbsent(int key, double ifAbsent) {
        return ifAbsent;
    }

    public double getOrThrow(int key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key) {
        return false;
    }

    public boolean containsValue(double value) {
        return false;
    }

    public void forEachValue(DoubleProcedure procedure) {
    }

    public void forEachKey(IntProcedure procedure) {
    }

    public void forEachKeyValue(IntDoubleProcedure procedure) {
    }

    public LazyIntIterable keysView() {
        return new IntDoubleHashMap(0).keysView();
    }

    public ImmutableIntDoubleMap select(IntDoublePredicate predicate) {
        return this;
    }

    public ImmutableIntDoubleMap reject(IntDoublePredicate predicate) {
        return this;
    }

    public ImmutableIntDoubleMap toImmutable() {
        return this;
    }

    public DoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public void forEach(DoubleProcedure procedure) {
    }

    public int count(DoublePredicate predicate) {
        return 0;
    }

    public double sum() {
        return 0.0;
    }

    public double min() {
        throw new NoSuchElementException();
    }

    public double max() {
        throw new NoSuchElementException();
    }

    public double maxIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double minIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public double[] toSortedArray() {
        return new double[0];
    }

    public MutableDoubleList toSortedList() {
        return new DoubleArrayList();
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return true;
    }

    public ImmutableDoubleCollection select(DoublePredicate predicate) {
        return DoubleLists.immutable.with();
    }

    public ImmutableDoubleCollection reject(DoublePredicate predicate) {
        return DoubleLists.immutable.with();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Lists.immutable.of();
    }

    public double[] toArray() {
        return new double[0];
    }

    public boolean contains(double value) {
        return false;
    }

    public boolean containsAll(double ... source) {
        return source.length == 0;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.isEmpty();
    }

    public MutableDoubleList toList() {
        return new DoubleArrayList();
    }

    public MutableDoubleSet toSet() {
        return new DoubleHashSet();
    }

    public MutableDoubleBag toBag() {
        return new DoubleHashBag();
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public ImmutableIntDoubleMap newWithKeyValue(int key, double value) {
        return new ImmutableIntDoubleSingletonMap(key, value);
    }

    public ImmutableIntDoubleMap newWithoutKey(int key) {
        return this;
    }

    public ImmutableIntDoubleMap newWithoutAllKeys(IntIterable keys) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public MutableIntSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableDoubleCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntDoubleMap)) {
            return false;
        }
        IntDoubleMap map = (IntDoubleMap)obj;
        return map.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class InternalDoubleIterator
    implements DoubleIterator {
        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public double next() {
            throw new NoSuchElementException();
        }
    }
}

