/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction0;
import com.gs.collections.api.block.function.primitive.ByteToByteFunction;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.DoubleToByteFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.DoubleBytePredicate;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleByteProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.DoubleByteMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleByteMap;
import com.gs.collections.api.map.primitive.MutableDoubleByteMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.api.set.primitive.ImmutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.block.factory.primitive.DoublePredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedByteCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableByteCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.factory.primitive.DoubleByteMaps;
import com.gs.collections.impl.factory.primitive.DoubleSets;
import com.gs.collections.impl.lazy.primitive.CollectDoubleToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectDoubleIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedDoubleByteMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableDoubleByteMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedDoubleSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleByteHashMap
implements MutableDoubleByteMap,
Externalizable {
    static final byte EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_KEY = 0.0;
    private static final double REMOVED_KEY = 1.0;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private double[] keys;
    private byte[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public DoubleByteHashMap() {
        this.allocateTable(16);
    }

    public DoubleByteHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public DoubleByteHashMap(DoubleByteMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static DoubleByteHashMap newWithKeysValues(double key1, byte value1) {
        return new DoubleByteHashMap(1).withKeyValue(key1, value1);
    }

    public static DoubleByteHashMap newWithKeysValues(double key1, byte value1, double key2, byte value2) {
        return new DoubleByteHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static DoubleByteHashMap newWithKeysValues(double key1, byte value1, double key2, byte value2, double key3, byte value3) {
        return new DoubleByteHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static DoubleByteHashMap newWithKeysValues(double key1, byte value1, double key2, byte value2, double key3, byte value3, double key4, byte value4) {
        return new DoubleByteHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleByteMap)) {
            return false;
        }
        DoubleByteMap other = (DoubleByteMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0) || other.containsKey(1.0)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0) || this.sentinelValues.zeroValue != other.getOrThrow(0.0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0) || this.sentinelValues.oneValue != other.getOrThrow(1.0))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleByteHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32) ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32) ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(Double.doubleToLongBits(this.keys[i]) ^ Double.doubleToLongBits(this.keys[i]) >>> 32) ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0.0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1.0)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                double key = this.keys[i];
                if (!DoubleByteHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ByteIterator byteIterator() {
        return new InternalByteIterator();
    }

    public byte[] toArray() {
        byte[] array = new byte[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(byte value) {
        return this.containsValue(value);
    }

    public boolean containsAll(byte ... source) {
        for (byte each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ByteIterable source) {
        return source.allSatisfy(new BytePredicate(){

            public boolean accept(byte value) {
                return DoubleByteHashMap.this.contains(value);
            }
        });
    }

    public void forEach(ByteProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableByteCollection select(BytePredicate predicate) {
        ByteArrayList result = new ByteArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableByteCollection reject(BytePredicate predicate) {
        ByteArrayList result = new ByteArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public byte detectIfNone(BytePredicate predicate, byte value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(BytePredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(BytePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectByteToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableByteList toList() {
        return ByteArrayList.newList((ByteIterable)this);
    }

    public MutableByteSet toSet() {
        return ByteHashSet.newSet((ByteIterable)this);
    }

    public MutableByteBag toBag() {
        return ByteHashBag.newBag((ByteIterable)this);
    }

    public LazyByteIterable asLazy() {
        return new LazyByteIterableAdapter((ByteIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0.0);
        Arrays.fill(this.values, (byte)0);
    }

    public void put(double key, byte value) {
        if (DoubleByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (DoubleByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values[index] = value;
            return;
        }
        if (Double.compare(this.keys[index], 1.0) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(DoubleByteMap map) {
        map.forEachKeyValue(new DoubleByteProcedure(){

            public void value(double key, byte value) {
                DoubleByteHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(double key) {
        if (DoubleByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = (byte)0;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (DoubleByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = (byte)0;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(double key) {
        this.removeKey(key);
    }

    public byte removeKeyIfAbsent(double key, byte value) {
        if (DoubleByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            byte oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = (byte)0;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (DoubleByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            byte oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = (byte)0;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0;
            byte oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public byte getIfAbsentPut(double key, byte value) {
        if (DoubleByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (DoubleByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public byte getIfAbsentPut(double key, ByteFunction0 function) {
        byte value;
        if (DoubleByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (DoubleByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> byte getIfAbsentPutWith(double key, ByteFunction<? super P> function, P parameter) {
        byte value;
        if (DoubleByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value2 = function.byteValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value3 = function.byteValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (DoubleByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value4 = function.byteValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value5 = function.byteValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.byteValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public byte getIfAbsentPutWithKey(double key, DoubleToByteFunction function) {
        byte value;
        if (DoubleByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                byte value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            byte value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (DoubleByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                byte value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            byte value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public byte updateValue(double key, byte initialValueIfAbsent, ByteToByteFunction function) {
        byte value;
        if (DoubleByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (Double.compare(this.keys[index], 1.0) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public DoubleByteHashMap withKeyValue(double key1, byte value1) {
        this.put(key1, value1);
        return this;
    }

    public DoubleByteHashMap withKeysValues(double key1, byte value1, double key2, byte value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public DoubleByteHashMap withKeysValues(double key1, byte value1, double key2, byte value2, double key3, byte value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public DoubleByteHashMap withKeysValues(double key1, byte value1, double key2, byte value2, double key3, byte value3, double key4, byte value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public DoubleByteHashMap withoutKey(double key) {
        this.removeKey(key);
        return this;
    }

    public DoubleByteHashMap withoutAllKeys(DoubleIterable keys) {
        keys.forEach(new DoubleProcedure(){

            public void value(double key) {
                DoubleByteHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableDoubleByteMap asUnmodifiable() {
        return new UnmodifiableDoubleByteMap(this);
    }

    public MutableDoubleByteMap asSynchronized() {
        return new SynchronizedDoubleByteMap(this);
    }

    public ImmutableDoubleByteMap toImmutable() {
        return DoubleByteMaps.immutable.ofAll((DoubleByteMap)this);
    }

    public byte get(double key) {
        return this.getIfAbsent(key, (byte)0);
    }

    public byte getIfAbsent(double key, byte ifAbsent) {
        if (DoubleByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public byte getOrThrow(double key) {
        if (DoubleByteHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleByteHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (DoubleByteHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(double key) {
        if (DoubleByteHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (DoubleByteHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Double.compare(this.keys[this.probe(key)], key) == 0;
    }

    public boolean containsValue(byte value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(ByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0);
            }
        }
        for (double key : this.keys) {
            if (!DoubleByteHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(DoubleByteProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyDoubleIterable keysView() {
        return new KeysView();
    }

    public DoubleByteHashMap select(DoubleBytePredicate predicate) {
        DoubleByteHashMap result = new DoubleByteHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public DoubleByteHashMap reject(DoubleBytePredicate predicate) {
        DoubleByteHashMap result = new DoubleByteHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (long)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (long)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public byte max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ByteIterator iterator = this.byteIterator();
        byte max = iterator.next();
        while (iterator.hasNext()) {
            byte value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public byte maxIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public byte min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        ByteIterator iterator = this.byteIterator();
        byte min = iterator.next();
        while (iterator.hasNext()) {
            byte value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public byte minIfEmpty(byte defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        byte[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            byte first = sortedArray[middleIndex];
            byte second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public byte[] toSortedArray() {
        byte[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableByteList toSortedList() {
        return ByteArrayList.newList((ByteIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeDouble(0.0);
                out.writeByte(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeDouble(1.0);
                out.writeByte(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeDouble(this.keys[i]);
            out.writeByte(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readDouble(), in.readByte());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        double[] old = this.keys;
        byte[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!DoubleByteHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(double element) {
        int index = this.spread(element);
        double keyAtIndex = this.keys[index];
        if (Double.compare(keyAtIndex, element) == 0 || Double.compare(keyAtIndex, 0.0) == 0) {
            return index;
        }
        int removedIndex = Double.compare(keyAtIndex, 1.0) == 0 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (Double.compare(this.keys[nextIndex &= this.keys.length - 1], element) == 0) {
                return nextIndex;
            }
            if (Double.compare(this.keys[nextIndex], 1.0) == 0) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (Double.compare(this.keys[nextIndex], 0.0) == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(double element) {
        long code = Double.doubleToLongBits(element);
        code = (code ^ 0xFFFFFFFFFFFFFFFFL) + (code << 18);
        code = (code << 18) - code - 1L;
        code ^= code >>> 31;
        code *= 21L;
        code += (code << 2) + (code << 4);
        code ^= code >>> 11;
        code += code << 6;
        code ^= code >>> 22;
        return (int)code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new double[sizeToAllocate];
        this.values = new byte[sizeToAllocate];
    }

    private static boolean isEmptyKey(double key) {
        return Double.compare(key, 0.0) == 0;
    }

    private static boolean isRemovedKey(double key) {
        return Double.compare(key, 1.0) == 0;
    }

    private static boolean isNonSentinel(double key) {
        return !DoubleByteHashMap.isEmptyKey(key) && !DoubleByteHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableDoubleSet keySet() {
        return new KeySet();
    }

    public MutableByteCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableByteCollection {
        private ValuesCollection() {
        }

        public void clear() {
            DoubleByteHashMap.this.clear();
        }

        public MutableByteCollection select(BytePredicate predicate) {
            return DoubleByteHashMap.this.select(predicate);
        }

        public MutableByteCollection reject(BytePredicate predicate) {
            return DoubleByteHashMap.this.reject(predicate);
        }

        public byte detectIfNone(BytePredicate predicate, byte ifNone) {
            return DoubleByteHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(ByteToObjectFunction<? extends V> function) {
            return DoubleByteHashMap.this.collect(function);
        }

        public long sum() {
            return DoubleByteHashMap.this.sum();
        }

        public byte max() {
            return DoubleByteHashMap.this.max();
        }

        public byte maxIfEmpty(byte defaultValue) {
            return DoubleByteHashMap.this.maxIfEmpty(defaultValue);
        }

        public byte min() {
            return DoubleByteHashMap.this.min();
        }

        public byte minIfEmpty(byte defaultValue) {
            return DoubleByteHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return DoubleByteHashMap.this.average();
        }

        public double median() {
            return DoubleByteHashMap.this.median();
        }

        public byte[] toSortedArray() {
            return DoubleByteHashMap.this.toSortedArray();
        }

        public MutableByteList toSortedList() {
            return DoubleByteHashMap.this.toSortedList();
        }

        public MutableByteCollection with(byte element) {
            throw new UnsupportedOperationException();
        }

        public MutableByteCollection without(byte element) {
            throw new UnsupportedOperationException();
        }

        public MutableByteCollection withAll(ByteIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableByteCollection withoutAll(ByteIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableByteCollection asUnmodifiable() {
            return UnmodifiableByteCollection.of(this);
        }

        public MutableByteCollection asSynchronized() {
            return SynchronizedByteCollection.of(this);
        }

        public ImmutableByteCollection toImmutable() {
            return ByteLists.immutable.withAll((ByteIterable)this);
        }

        public boolean contains(byte value) {
            return DoubleByteHashMap.this.containsValue(value);
        }

        public boolean containsAll(byte ... source) {
            return DoubleByteHashMap.this.containsAll(source);
        }

        public boolean containsAll(ByteIterable source) {
            return DoubleByteHashMap.this.containsAll(source);
        }

        public MutableByteList toList() {
            return DoubleByteHashMap.this.toList();
        }

        public MutableByteSet toSet() {
            return DoubleByteHashMap.this.toSet();
        }

        public MutableByteBag toBag() {
            return DoubleByteHashMap.this.toBag();
        }

        public LazyByteIterable asLazy() {
            return new LazyByteIterableAdapter((ByteIterable)this);
        }

        public boolean isEmpty() {
            return DoubleByteHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleByteHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleByteHashMap.this.sentinelValues != null) {
                    if (DoubleByteHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(DoubleByteHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (DoubleByteHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(DoubleByteHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < DoubleByteHashMap.this.keys.length; ++i) {
                    double key = DoubleByteHashMap.this.keys[i];
                    if (!DoubleByteHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(DoubleByteHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ByteIterator byteIterator() {
            return DoubleByteHashMap.this.byteIterator();
        }

        public void forEach(ByteProcedure procedure) {
            DoubleByteHashMap.this.forEach(procedure);
        }

        public int count(BytePredicate predicate) {
            return DoubleByteHashMap.this.count(predicate);
        }

        public boolean anySatisfy(BytePredicate predicate) {
            return DoubleByteHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(BytePredicate predicate) {
            return DoubleByteHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(BytePredicate predicate) {
            return DoubleByteHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(byte element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(byte ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(ByteIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(byte item) {
            int oldSize = DoubleByteHashMap.this.size();
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && item == DoubleByteHashMap.this.sentinelValues.zeroValue) {
                    DoubleByteHashMap.this.removeKey(0.0);
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && item == DoubleByteHashMap.this.sentinelValues.oneValue) {
                    DoubleByteHashMap.this.removeKey(1.0);
                }
            }
            for (int i = 0; i < DoubleByteHashMap.this.keys.length; ++i) {
                if (!DoubleByteHashMap.isNonSentinel(DoubleByteHashMap.this.keys[i]) || item != DoubleByteHashMap.this.values[i]) continue;
                DoubleByteHashMap.this.removeKey(DoubleByteHashMap.this.keys[i]);
            }
            return oldSize != DoubleByteHashMap.this.size();
        }

        public boolean removeAll(ByteIterable source) {
            int oldSize = DoubleByteHashMap.this.size();
            ByteIterator iterator = source.byteIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != DoubleByteHashMap.this.size();
        }

        public boolean removeAll(byte ... source) {
            int oldSize = DoubleByteHashMap.this.size();
            for (byte item : source) {
                this.remove(item);
            }
            return oldSize != DoubleByteHashMap.this.size();
        }

        public int size() {
            return DoubleByteHashMap.this.size();
        }

        public byte[] toArray() {
            return DoubleByteHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableDoubleSet {
        private KeySet() {
        }

        public DoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        public void forEach(DoubleProcedure procedure) {
            DoubleByteHashMap.this.forEachKey(procedure);
        }

        public int count(DoublePredicate predicate) {
            int count = 0;
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    ++count;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    ++count;
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return true;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return true;
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(double element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(double ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(DoubleIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(double key) {
            int oldSize = DoubleByteHashMap.this.size();
            DoubleByteHashMap.this.removeKey(key);
            return oldSize != DoubleByteHashMap.this.size();
        }

        public boolean removeAll(DoubleIterable source) {
            int oldSize = DoubleByteHashMap.this.size();
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                DoubleByteHashMap.this.removeKey(iterator.next());
            }
            return oldSize != DoubleByteHashMap.this.size();
        }

        public boolean removeAll(double ... source) {
            int oldSize = DoubleByteHashMap.this.size();
            for (double item : source) {
                DoubleByteHashMap.this.removeKey(item);
            }
            return oldSize != DoubleByteHashMap.this.size();
        }

        public void clear() {
            DoubleByteHashMap.this.clear();
        }

        public MutableDoubleSet select(DoublePredicate predicate) {
            DoubleHashSet result = new DoubleHashSet();
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    result.add(0.0);
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    result.add(1.0);
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableDoubleSet reject(DoublePredicate predicate) {
            DoubleHashSet result = new DoubleHashSet();
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    result.add(0.0);
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    result.add(1.0);
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableDoubleSet with(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleSet without(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleSet withAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleSet withoutAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return 0.0;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return 1.0;
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0.0));
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1.0));
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableDoubleSet asUnmodifiable() {
            return UnmodifiableDoubleSet.of(this);
        }

        public MutableDoubleSet asSynchronized() {
            return SynchronizedDoubleSet.of(this);
        }

        public double sum() {
            double sum = 0.0;
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0.0;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey) {
                    sum += 1.0;
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key)) continue;
                sum += key;
            }
            return sum;
        }

        public double max() {
            if (DoubleByteHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double max = 0.0;
            boolean isMaxSet = false;
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0.0;
                    isMaxSet = true;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || Double.compare(max, 1.0) < 0)) {
                    max = 1.0;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < DoubleByteHashMap.this.keys.length; ++i) {
                if (!DoubleByteHashMap.isNonSentinel(DoubleByteHashMap.this.keys[i]) || isMaxSet && Double.compare(max, DoubleByteHashMap.this.keys[i]) >= 0) continue;
                max = DoubleByteHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public double maxIfEmpty(double defaultValue) {
            if (DoubleByteHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double min() {
            if (DoubleByteHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double min = 0.0;
            boolean isMinSet = false;
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0.0;
                    isMinSet = true;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && (!isMinSet || Double.compare(1.0, min) < 0)) {
                    min = 1.0;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < DoubleByteHashMap.this.keys.length; ++i) {
                if (!DoubleByteHashMap.isNonSentinel(DoubleByteHashMap.this.keys[i]) || isMinSet && Double.compare(DoubleByteHashMap.this.keys[i], min) >= 0) continue;
                min = DoubleByteHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public double minIfEmpty(double defaultValue) {
            if (DoubleByteHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            double[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                double first = sortedArray[middleIndex];
                double second = sortedArray[middleIndex - 1];
                return (first + second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public double[] toSortedArray() {
            double[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableDoubleList toSortedList() {
            return DoubleArrayList.newList((DoubleIterable)this).sortThis();
        }

        public double[] toArray() {
            int size = DoubleByteHashMap.this.size();
            final double[] result = new double[size];
            DoubleByteHashMap.this.forEachKey(new DoubleProcedure(){
                private int index;

                public void value(double each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(double value) {
            return DoubleByteHashMap.this.containsKey(value);
        }

        public boolean containsAll(double ... source) {
            for (double item : source) {
                if (DoubleByteHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(DoubleIterable source) {
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                if (DoubleByteHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableDoubleList toList() {
            return DoubleArrayList.newList((DoubleIterable)this);
        }

        public MutableDoubleSet toSet() {
            return DoubleHashSet.newSet((DoubleIterable)this);
        }

        public MutableDoubleBag toBag() {
            return DoubleHashBag.newBag((DoubleIterable)this);
        }

        public LazyDoubleIterable asLazy() {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }

        public DoubleSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableDoubleSet toImmutable() {
            return DoubleSets.immutable.withAll((DoubleIterable)this);
        }

        public int size() {
            return DoubleByteHashMap.this.size();
        }

        public boolean isEmpty() {
            return DoubleByteHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleByteHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DoubleSet)) {
                return false;
            }
            DoubleSet other = (DoubleSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey) {
                    result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32);
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey) {
                    result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32);
                }
            }
            for (int i = 0; i < DoubleByteHashMap.this.keys.length; ++i) {
                if (!DoubleByteHashMap.isNonSentinel(DoubleByteHashMap.this.keys[i])) continue;
                result += (int)(Double.doubleToLongBits(DoubleByteHashMap.this.keys[i]) ^ Double.doubleToLongBits(DoubleByteHashMap.this.keys[i]) >>> 32);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleByteHashMap.this.sentinelValues != null) {
                    if (DoubleByteHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0));
                        first = false;
                    }
                    if (DoubleByteHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0));
                        first = false;
                    }
                }
                for (double key : DoubleByteHashMap.this.keys) {
                    if (!DoubleByteHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements DoubleIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleByteHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleByteHashMap.this.containsKey(0.0)) {
                    return 0.0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleByteHashMap.this.containsKey(1.0)) {
                    return 1.0;
                }
            }
            double[] keys = DoubleByteHashMap.this.keys;
            while (!DoubleByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyDoubleIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return DoubleByteHashMap.this.size();
        }

        public boolean isEmpty() {
            return DoubleByteHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleByteHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleByteHashMap.this.sentinelValues != null) {
                    if (DoubleByteHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0));
                        first = false;
                    }
                    if (DoubleByteHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0));
                        first = false;
                    }
                }
                for (double key : DoubleByteHashMap.this.keys) {
                    if (!DoubleByteHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public DoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        public boolean contains(double key) {
            return DoubleByteHashMap.this.containsKey(key);
        }

        public boolean containsAll(double ... keys) {
            for (double key : keys) {
                if (DoubleByteHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(DoubleIterable source) {
            return source.allSatisfy(new DoublePredicate(){

                public boolean accept(double key) {
                    return DoubleByteHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(DoubleProcedure procedure) {
            DoubleByteHashMap.this.forEachKey(procedure);
        }

        public int count(DoublePredicate predicate) {
            int count = 0;
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    ++count;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    ++count;
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return true;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return true;
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyDoubleIterable select(DoublePredicate predicate) {
            return new SelectDoubleIterable((DoubleIterable)this, predicate);
        }

        public LazyDoubleIterable reject(DoublePredicate predicate) {
            return new SelectDoubleIterable((DoubleIterable)this, DoublePredicates.not(predicate));
        }

        public double detectIfNone(DoublePredicate predicate, double value) {
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return 0.0;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return 1.0;
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(DoubleToObjectFunction<? extends V> function) {
            return new CollectDoubleToObjectIterable<V>((DoubleIterable)this, function);
        }

        public double sum() {
            double result = 0.0;
            if (DoubleByteHashMap.this.sentinelValues != null) {
                if (DoubleByteHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0.0;
                }
                if (DoubleByteHashMap.this.sentinelValues.containsOneKey) {
                    result += 1.0;
                }
            }
            for (double key : DoubleByteHashMap.this.keys) {
                if (!DoubleByteHashMap.isNonSentinel(key)) continue;
                result += key;
            }
            return result;
        }

        public double max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            DoubleIterator iterator = this.doubleIterator();
            double max = iterator.next();
            while (iterator.hasNext()) {
                double value = iterator.next();
                if (Double.compare(max, value) >= 0) continue;
                max = value;
            }
            return max;
        }

        public double min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            DoubleIterator iterator = this.doubleIterator();
            double min = iterator.next();
            while (iterator.hasNext()) {
                double value = iterator.next();
                if (Double.compare(value, min) >= 0) continue;
                min = value;
            }
            return min;
        }

        public double minIfEmpty(double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double maxIfEmpty(double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            double[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                double first = sortedArray[middleIndex];
                double second = sortedArray[middleIndex - 1];
                return (first + second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public double[] toSortedArray() {
            double[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public double[] toArray() {
            int size = DoubleByteHashMap.this.size();
            final double[] result = new double[size];
            DoubleByteHashMap.this.forEachKey(new DoubleProcedure(){
                private int index;

                public void value(double each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public MutableDoubleList toList() {
            return DoubleArrayList.newList((DoubleIterable)this);
        }

        public MutableDoubleList toSortedList() {
            return DoubleArrayList.newList((DoubleIterable)this).sortThis();
        }

        public MutableDoubleSet toSet() {
            return DoubleHashSet.newSet((DoubleIterable)this);
        }

        public MutableDoubleBag toBag() {
            return DoubleHashBag.newBag((DoubleIterable)this);
        }

        public LazyDoubleIterable asLazy() {
            return this;
        }
    }

    private class InternalByteIterator
    implements ByteIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalByteIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleByteHashMap.this.size();
        }

        public byte next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleByteHashMap.this.containsKey(0.0)) {
                    return DoubleByteHashMap.this.get(0.0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleByteHashMap.this.containsKey(1.0)) {
                    return DoubleByteHashMap.this.get(1.0);
                }
            }
            double[] keys = DoubleByteHashMap.this.keys;
            while (!DoubleByteHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            byte result = DoubleByteHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private byte zeroValue;
        private byte oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(byte value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

