/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleDoublePredicate;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.DoubleDoubleMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleDoubleMap;
import com.gs.collections.api.map.primitive.MutableDoubleDoubleMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.api.set.primitive.ImmutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.block.factory.primitive.DoublePredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedDoubleCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.DoubleDoubleMaps;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.factory.primitive.DoubleSets;
import com.gs.collections.impl.lazy.primitive.CollectDoubleToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectDoubleIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedDoubleDoubleMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableDoubleDoubleMap;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedDoubleSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleDoubleHashMap
implements MutableDoubleDoubleMap,
Externalizable {
    static final double EMPTY_VALUE = 0.0;
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_KEY = 0.0;
    private static final double REMOVED_KEY = 1.0;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private double[] keys;
    private double[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public DoubleDoubleHashMap() {
        this.allocateTable(16);
    }

    public DoubleDoubleHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public DoubleDoubleHashMap(DoubleDoubleMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static DoubleDoubleHashMap newWithKeysValues(double key1, double value1) {
        return new DoubleDoubleHashMap(1).withKeyValue(key1, value1);
    }

    public static DoubleDoubleHashMap newWithKeysValues(double key1, double value1, double key2, double value2) {
        return new DoubleDoubleHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static DoubleDoubleHashMap newWithKeysValues(double key1, double value1, double key2, double value2, double key3, double value3) {
        return new DoubleDoubleHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static DoubleDoubleHashMap newWithKeysValues(double key1, double value1, double key2, double value2, double key3, double value3, double key4, double value4) {
        return new DoubleDoubleHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleDoubleMap)) {
            return false;
        }
        DoubleDoubleMap other = (DoubleDoubleMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0) || other.containsKey(1.0)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0) || Double.compare(this.sentinelValues.zeroValue, other.getOrThrow(0.0)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0) || Double.compare(this.sentinelValues.oneValue, other.getOrThrow(1.0)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleDoubleHashMap.isNonSentinel(key) || other.containsKey(key) && Double.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32) ^ (int)(Double.doubleToLongBits(this.sentinelValues.zeroValue) ^ Double.doubleToLongBits(this.sentinelValues.zeroValue) >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32) ^ (int)(Double.doubleToLongBits(this.sentinelValues.oneValue) ^ Double.doubleToLongBits(this.sentinelValues.oneValue) >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(Double.doubleToLongBits(this.keys[i]) ^ Double.doubleToLongBits(this.keys[i]) >>> 32) ^ (int)(Double.doubleToLongBits(this.values[i]) ^ Double.doubleToLongBits(this.values[i]) >>> 32);
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0.0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1.0)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                double key = this.keys[i];
                if (!DoubleDoubleHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public double[] toArray() {
        double[] array = new double[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(double value) {
        return this.containsValue(value);
    }

    public boolean containsAll(double ... source) {
        for (double each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.allSatisfy(new DoublePredicate(){

            public boolean accept(double value) {
                return DoubleDoubleHashMap.this.contains(value);
            }
        });
    }

    public void forEach(DoubleProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableDoubleCollection select(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableDoubleCollection reject(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public double detectIfNone(DoublePredicate predicate, double value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(DoublePredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newList((DoubleIterable)this);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet((DoubleIterable)this);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag((DoubleIterable)this);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0.0);
        Arrays.fill(this.values, 0.0);
    }

    public void put(double key, double value) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values[index] = value;
            return;
        }
        if (Double.compare(this.keys[index], 1.0) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(DoubleDoubleMap map) {
        map.forEachKeyValue(new DoubleDoubleProcedure(){

            public void value(double key, double value) {
                DoubleDoubleHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(double key) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0;
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(double key) {
        this.removeKey(key);
    }

    public double removeKeyIfAbsent(double key, double value) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            double oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            double oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0;
            double oldValue = this.values[index];
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public double getIfAbsentPut(double key, double value) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public double getIfAbsentPut(double key, DoubleFunction0 function) {
        double value;
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> double getIfAbsentPutWith(double key, DoubleFunction<? super P> function, P parameter) {
        double value;
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value2 = function.doubleValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value3 = function.doubleValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value4 = function.doubleValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value5 = function.doubleValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.doubleValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public double getIfAbsentPutWithKey(double key, DoubleToDoubleFunction function) {
        double value;
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public double updateValue(double key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        double value;
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (Double.compare(this.keys[index], 1.0) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public DoubleDoubleHashMap withKeyValue(double key1, double value1) {
        this.put(key1, value1);
        return this;
    }

    public DoubleDoubleHashMap withKeysValues(double key1, double value1, double key2, double value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public DoubleDoubleHashMap withKeysValues(double key1, double value1, double key2, double value2, double key3, double value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public DoubleDoubleHashMap withKeysValues(double key1, double value1, double key2, double value2, double key3, double value3, double key4, double value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public DoubleDoubleHashMap withoutKey(double key) {
        this.removeKey(key);
        return this;
    }

    public DoubleDoubleHashMap withoutAllKeys(DoubleIterable keys) {
        keys.forEach(new DoubleProcedure(){

            public void value(double key) {
                DoubleDoubleHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableDoubleDoubleMap asUnmodifiable() {
        return new UnmodifiableDoubleDoubleMap(this);
    }

    public MutableDoubleDoubleMap asSynchronized() {
        return new SynchronizedDoubleDoubleMap(this);
    }

    public ImmutableDoubleDoubleMap toImmutable() {
        return DoubleDoubleMaps.immutable.ofAll((DoubleDoubleMap)this);
    }

    public double get(double key) {
        return this.getIfAbsent(key, 0.0);
    }

    public double getIfAbsent(double key, double ifAbsent) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public double getOrThrow(double key) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (DoubleDoubleHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(double key) {
        if (DoubleDoubleHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (DoubleDoubleHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Double.compare(this.keys[this.probe(key)], key) == 0;
    }

    public boolean containsValue(double value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i]) || Double.compare(this.values[i], value) != 0) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0);
            }
        }
        for (double key : this.keys) {
            if (!DoubleDoubleHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(DoubleDoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyDoubleIterable keysView() {
        return new KeysView();
    }

    public DoubleDoubleHashMap select(DoubleDoublePredicate predicate) {
        DoubleDoubleHashMap result = new DoubleDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public DoubleDoubleHashMap reject(DoubleDoublePredicate predicate) {
        DoubleDoubleHashMap result = new DoubleDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public double sum() {
        double result = 0.0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.values[i];
        }
        return result;
    }

    public double max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        DoubleIterator iterator = this.doubleIterator();
        double max = iterator.next();
        while (iterator.hasNext()) {
            double value = iterator.next();
            if (Double.compare(max, value) >= 0) continue;
            max = value;
        }
        return max;
    }

    public double maxIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        DoubleIterator iterator = this.doubleIterator();
        double min = iterator.next();
        while (iterator.hasNext()) {
            double value = iterator.next();
            if (Double.compare(value, min) >= 0) continue;
            min = value;
        }
        return min;
    }

    public double minIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList((DoubleIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeDouble(0.0);
                out.writeDouble(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeDouble(1.0);
                out.writeDouble(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeDouble(this.keys[i]);
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readDouble(), in.readDouble());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        double[] old = this.keys;
        double[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!DoubleDoubleHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(double element) {
        int index = this.spread(element);
        double keyAtIndex = this.keys[index];
        if (Double.compare(keyAtIndex, element) == 0 || Double.compare(keyAtIndex, 0.0) == 0) {
            return index;
        }
        int removedIndex = Double.compare(keyAtIndex, 1.0) == 0 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (Double.compare(this.keys[nextIndex &= this.keys.length - 1], element) == 0) {
                return nextIndex;
            }
            if (Double.compare(this.keys[nextIndex], 1.0) == 0) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (Double.compare(this.keys[nextIndex], 0.0) == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(double element) {
        long code = Double.doubleToLongBits(element);
        code = (code ^ 0xFFFFFFFFFFFFFFFFL) + (code << 18);
        code = (code << 18) - code - 1L;
        code ^= code >>> 31;
        code *= 21L;
        code += (code << 2) + (code << 4);
        code ^= code >>> 11;
        code += code << 6;
        code ^= code >>> 22;
        return (int)code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new double[sizeToAllocate];
        this.values = new double[sizeToAllocate];
    }

    private static boolean isEmptyKey(double key) {
        return Double.compare(key, 0.0) == 0;
    }

    private static boolean isRemovedKey(double key) {
        return Double.compare(key, 1.0) == 0;
    }

    private static boolean isNonSentinel(double key) {
        return !DoubleDoubleHashMap.isEmptyKey(key) && !DoubleDoubleHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableDoubleSet keySet() {
        return new KeySet();
    }

    public MutableDoubleCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableDoubleCollection {
        private ValuesCollection() {
        }

        public void clear() {
            DoubleDoubleHashMap.this.clear();
        }

        public MutableDoubleCollection select(DoublePredicate predicate) {
            return DoubleDoubleHashMap.this.select(predicate);
        }

        public MutableDoubleCollection reject(DoublePredicate predicate) {
            return DoubleDoubleHashMap.this.reject(predicate);
        }

        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            return DoubleDoubleHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
            return DoubleDoubleHashMap.this.collect(function);
        }

        public double sum() {
            return DoubleDoubleHashMap.this.sum();
        }

        public double max() {
            return DoubleDoubleHashMap.this.max();
        }

        public double maxIfEmpty(double defaultValue) {
            return DoubleDoubleHashMap.this.maxIfEmpty(defaultValue);
        }

        public double min() {
            return DoubleDoubleHashMap.this.min();
        }

        public double minIfEmpty(double defaultValue) {
            return DoubleDoubleHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return DoubleDoubleHashMap.this.average();
        }

        public double median() {
            return DoubleDoubleHashMap.this.median();
        }

        public double[] toSortedArray() {
            return DoubleDoubleHashMap.this.toSortedArray();
        }

        public MutableDoubleList toSortedList() {
            return DoubleDoubleHashMap.this.toSortedList();
        }

        public MutableDoubleCollection with(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection without(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection withAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection withoutAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection asUnmodifiable() {
            return UnmodifiableDoubleCollection.of(this);
        }

        public MutableDoubleCollection asSynchronized() {
            return SynchronizedDoubleCollection.of(this);
        }

        public ImmutableDoubleCollection toImmutable() {
            return DoubleLists.immutable.withAll((DoubleIterable)this);
        }

        public boolean contains(double value) {
            return DoubleDoubleHashMap.this.containsValue(value);
        }

        public boolean containsAll(double ... source) {
            return DoubleDoubleHashMap.this.containsAll(source);
        }

        public boolean containsAll(DoubleIterable source) {
            return DoubleDoubleHashMap.this.containsAll(source);
        }

        public MutableDoubleList toList() {
            return DoubleDoubleHashMap.this.toList();
        }

        public MutableDoubleSet toSet() {
            return DoubleDoubleHashMap.this.toSet();
        }

        public MutableDoubleBag toBag() {
            return DoubleDoubleHashMap.this.toBag();
        }

        public LazyDoubleIterable asLazy() {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }

        public boolean isEmpty() {
            return DoubleDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleDoubleHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleDoubleHashMap.this.sentinelValues != null) {
                    if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(DoubleDoubleHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(DoubleDoubleHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < DoubleDoubleHashMap.this.keys.length; ++i) {
                    double key = DoubleDoubleHashMap.this.keys[i];
                    if (!DoubleDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(DoubleDoubleHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public DoubleIterator doubleIterator() {
            return DoubleDoubleHashMap.this.doubleIterator();
        }

        public void forEach(DoubleProcedure procedure) {
            DoubleDoubleHashMap.this.forEach(procedure);
        }

        public int count(DoublePredicate predicate) {
            return DoubleDoubleHashMap.this.count(predicate);
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            return DoubleDoubleHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            return DoubleDoubleHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            return DoubleDoubleHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(double element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(double ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(DoubleIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(double item) {
            int oldSize = DoubleDoubleHashMap.this.size();
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && Double.compare(item, DoubleDoubleHashMap.this.sentinelValues.zeroValue) == 0) {
                    DoubleDoubleHashMap.this.removeKey(0.0);
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && Double.compare(item, DoubleDoubleHashMap.this.sentinelValues.oneValue) == 0) {
                    DoubleDoubleHashMap.this.removeKey(1.0);
                }
            }
            for (int i = 0; i < DoubleDoubleHashMap.this.keys.length; ++i) {
                if (!DoubleDoubleHashMap.isNonSentinel(DoubleDoubleHashMap.this.keys[i]) || Double.compare(item, DoubleDoubleHashMap.this.values[i]) != 0) continue;
                DoubleDoubleHashMap.this.removeKey(DoubleDoubleHashMap.this.keys[i]);
            }
            return oldSize != DoubleDoubleHashMap.this.size();
        }

        public boolean removeAll(DoubleIterable source) {
            int oldSize = DoubleDoubleHashMap.this.size();
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != DoubleDoubleHashMap.this.size();
        }

        public boolean removeAll(double ... source) {
            int oldSize = DoubleDoubleHashMap.this.size();
            for (double item : source) {
                this.remove(item);
            }
            return oldSize != DoubleDoubleHashMap.this.size();
        }

        public int size() {
            return DoubleDoubleHashMap.this.size();
        }

        public double[] toArray() {
            return DoubleDoubleHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableDoubleSet {
        private KeySet() {
        }

        public DoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        public void forEach(DoubleProcedure procedure) {
            DoubleDoubleHashMap.this.forEachKey(procedure);
        }

        public int count(DoublePredicate predicate) {
            int count = 0;
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    ++count;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    ++count;
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return true;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return true;
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(double element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(double ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(DoubleIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(double key) {
            int oldSize = DoubleDoubleHashMap.this.size();
            DoubleDoubleHashMap.this.removeKey(key);
            return oldSize != DoubleDoubleHashMap.this.size();
        }

        public boolean removeAll(DoubleIterable source) {
            int oldSize = DoubleDoubleHashMap.this.size();
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                DoubleDoubleHashMap.this.removeKey(iterator.next());
            }
            return oldSize != DoubleDoubleHashMap.this.size();
        }

        public boolean removeAll(double ... source) {
            int oldSize = DoubleDoubleHashMap.this.size();
            for (double item : source) {
                DoubleDoubleHashMap.this.removeKey(item);
            }
            return oldSize != DoubleDoubleHashMap.this.size();
        }

        public void clear() {
            DoubleDoubleHashMap.this.clear();
        }

        public MutableDoubleSet select(DoublePredicate predicate) {
            DoubleHashSet result = new DoubleHashSet();
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    result.add(0.0);
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    result.add(1.0);
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableDoubleSet reject(DoublePredicate predicate) {
            DoubleHashSet result = new DoubleHashSet();
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    result.add(0.0);
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    result.add(1.0);
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableDoubleSet with(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleSet without(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleSet withAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleSet withoutAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return 0.0;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return 1.0;
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0.0));
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1.0));
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableDoubleSet asUnmodifiable() {
            return UnmodifiableDoubleSet.of(this);
        }

        public MutableDoubleSet asSynchronized() {
            return SynchronizedDoubleSet.of(this);
        }

        public double sum() {
            double sum = 0.0;
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0.0;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey) {
                    sum += 1.0;
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key)) continue;
                sum += key;
            }
            return sum;
        }

        public double max() {
            if (DoubleDoubleHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double max = 0.0;
            boolean isMaxSet = false;
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0.0;
                    isMaxSet = true;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || Double.compare(max, 1.0) < 0)) {
                    max = 1.0;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < DoubleDoubleHashMap.this.keys.length; ++i) {
                if (!DoubleDoubleHashMap.isNonSentinel(DoubleDoubleHashMap.this.keys[i]) || isMaxSet && Double.compare(max, DoubleDoubleHashMap.this.keys[i]) >= 0) continue;
                max = DoubleDoubleHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public double maxIfEmpty(double defaultValue) {
            if (DoubleDoubleHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double min() {
            if (DoubleDoubleHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double min = 0.0;
            boolean isMinSet = false;
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0.0;
                    isMinSet = true;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && (!isMinSet || Double.compare(1.0, min) < 0)) {
                    min = 1.0;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < DoubleDoubleHashMap.this.keys.length; ++i) {
                if (!DoubleDoubleHashMap.isNonSentinel(DoubleDoubleHashMap.this.keys[i]) || isMinSet && Double.compare(DoubleDoubleHashMap.this.keys[i], min) >= 0) continue;
                min = DoubleDoubleHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public double minIfEmpty(double defaultValue) {
            if (DoubleDoubleHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            double[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                double first = sortedArray[middleIndex];
                double second = sortedArray[middleIndex - 1];
                return (first + second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public double[] toSortedArray() {
            double[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableDoubleList toSortedList() {
            return DoubleArrayList.newList((DoubleIterable)this).sortThis();
        }

        public double[] toArray() {
            int size = DoubleDoubleHashMap.this.size();
            final double[] result = new double[size];
            DoubleDoubleHashMap.this.forEachKey(new DoubleProcedure(){
                private int index;

                public void value(double each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(double value) {
            return DoubleDoubleHashMap.this.containsKey(value);
        }

        public boolean containsAll(double ... source) {
            for (double item : source) {
                if (DoubleDoubleHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(DoubleIterable source) {
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                if (DoubleDoubleHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableDoubleList toList() {
            return DoubleArrayList.newList((DoubleIterable)this);
        }

        public MutableDoubleSet toSet() {
            return DoubleHashSet.newSet((DoubleIterable)this);
        }

        public MutableDoubleBag toBag() {
            return DoubleHashBag.newBag((DoubleIterable)this);
        }

        public LazyDoubleIterable asLazy() {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }

        public DoubleSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableDoubleSet toImmutable() {
            return DoubleSets.immutable.withAll((DoubleIterable)this);
        }

        public int size() {
            return DoubleDoubleHashMap.this.size();
        }

        public boolean isEmpty() {
            return DoubleDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleDoubleHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DoubleSet)) {
                return false;
            }
            DoubleSet other = (DoubleSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32);
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32);
                }
            }
            for (int i = 0; i < DoubleDoubleHashMap.this.keys.length; ++i) {
                if (!DoubleDoubleHashMap.isNonSentinel(DoubleDoubleHashMap.this.keys[i])) continue;
                result += (int)(Double.doubleToLongBits(DoubleDoubleHashMap.this.keys[i]) ^ Double.doubleToLongBits(DoubleDoubleHashMap.this.keys[i]) >>> 32);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleDoubleHashMap.this.sentinelValues != null) {
                    if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0));
                        first = false;
                    }
                    if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0));
                        first = false;
                    }
                }
                for (double key : DoubleDoubleHashMap.this.keys) {
                    if (!DoubleDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements DoubleIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleDoubleHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleDoubleHashMap.this.containsKey(0.0)) {
                    return 0.0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleDoubleHashMap.this.containsKey(1.0)) {
                    return 1.0;
                }
            }
            double[] keys = DoubleDoubleHashMap.this.keys;
            while (!DoubleDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyDoubleIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return DoubleDoubleHashMap.this.size();
        }

        public boolean isEmpty() {
            return DoubleDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleDoubleHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleDoubleHashMap.this.sentinelValues != null) {
                    if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0));
                        first = false;
                    }
                    if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0));
                        first = false;
                    }
                }
                for (double key : DoubleDoubleHashMap.this.keys) {
                    if (!DoubleDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public DoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        public boolean contains(double key) {
            return DoubleDoubleHashMap.this.containsKey(key);
        }

        public boolean containsAll(double ... keys) {
            for (double key : keys) {
                if (DoubleDoubleHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(DoubleIterable source) {
            return source.allSatisfy(new DoublePredicate(){

                public boolean accept(double key) {
                    return DoubleDoubleHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(DoubleProcedure procedure) {
            DoubleDoubleHashMap.this.forEachKey(procedure);
        }

        public int count(DoublePredicate predicate) {
            int count = 0;
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    ++count;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    ++count;
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return true;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return true;
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyDoubleIterable select(DoublePredicate predicate) {
            return new SelectDoubleIterable((DoubleIterable)this, predicate);
        }

        public LazyDoubleIterable reject(DoublePredicate predicate) {
            return new SelectDoubleIterable((DoubleIterable)this, DoublePredicates.not(predicate));
        }

        public double detectIfNone(DoublePredicate predicate, double value) {
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return 0.0;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return 1.0;
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(DoubleToObjectFunction<? extends V> function) {
            return new CollectDoubleToObjectIterable<V>((DoubleIterable)this, function);
        }

        public double sum() {
            double result = 0.0;
            if (DoubleDoubleHashMap.this.sentinelValues != null) {
                if (DoubleDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0.0;
                }
                if (DoubleDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result += 1.0;
                }
            }
            for (double key : DoubleDoubleHashMap.this.keys) {
                if (!DoubleDoubleHashMap.isNonSentinel(key)) continue;
                result += key;
            }
            return result;
        }

        public double max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            DoubleIterator iterator = this.doubleIterator();
            double max = iterator.next();
            while (iterator.hasNext()) {
                double value = iterator.next();
                if (Double.compare(max, value) >= 0) continue;
                max = value;
            }
            return max;
        }

        public double min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            DoubleIterator iterator = this.doubleIterator();
            double min = iterator.next();
            while (iterator.hasNext()) {
                double value = iterator.next();
                if (Double.compare(value, min) >= 0) continue;
                min = value;
            }
            return min;
        }

        public double minIfEmpty(double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double maxIfEmpty(double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            double[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                double first = sortedArray[middleIndex];
                double second = sortedArray[middleIndex - 1];
                return (first + second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public double[] toSortedArray() {
            double[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public double[] toArray() {
            int size = DoubleDoubleHashMap.this.size();
            final double[] result = new double[size];
            DoubleDoubleHashMap.this.forEachKey(new DoubleProcedure(){
                private int index;

                public void value(double each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public MutableDoubleList toList() {
            return DoubleArrayList.newList((DoubleIterable)this);
        }

        public MutableDoubleList toSortedList() {
            return DoubleArrayList.newList((DoubleIterable)this).sortThis();
        }

        public MutableDoubleSet toSet() {
            return DoubleHashSet.newSet((DoubleIterable)this);
        }

        public MutableDoubleBag toBag() {
            return DoubleHashBag.newBag((DoubleIterable)this);
        }

        public LazyDoubleIterable asLazy() {
            return this;
        }
    }

    private class InternalDoubleIterator
    implements DoubleIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleDoubleHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleDoubleHashMap.this.containsKey(0.0)) {
                    return DoubleDoubleHashMap.this.get(0.0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleDoubleHashMap.this.containsKey(1.0)) {
                    return DoubleDoubleHashMap.this.get(1.0);
                }
            }
            double[] keys = DoubleDoubleHashMap.this.keys;
            while (!DoubleDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = DoubleDoubleHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private double zeroValue;
        private double oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(double value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && Double.compare(this.zeroValue, value) == 0;
            boolean valueEqualsOneValue = this.containsOneKey && Double.compare(this.oneValue, value) == 0;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

