/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.DoubleToIntFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntFunction0;
import com.gs.collections.api.block.function.primitive.IntToIntFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoubleIntPredicate;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleIntProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.MutableIntCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.DoubleIntMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleIntMap;
import com.gs.collections.api.map.primitive.MutableDoubleIntMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.DoubleSet;
import com.gs.collections.api.set.primitive.ImmutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.block.factory.primitive.DoublePredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedIntCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.DoubleIntMaps;
import com.gs.collections.impl.factory.primitive.DoubleSets;
import com.gs.collections.impl.factory.primitive.IntLists;
import com.gs.collections.impl.lazy.primitive.CollectDoubleToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectDoubleIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedDoubleIntMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableDoubleIntMap;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedDoubleSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleIntHashMap
implements MutableDoubleIntMap,
Externalizable {
    static final int EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_KEY = 0.0;
    private static final double REMOVED_KEY = 1.0;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private double[] keys;
    private int[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public DoubleIntHashMap() {
        this.allocateTable(16);
    }

    public DoubleIntHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public DoubleIntHashMap(DoubleIntMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static DoubleIntHashMap newWithKeysValues(double key1, int value1) {
        return new DoubleIntHashMap(1).withKeyValue(key1, value1);
    }

    public static DoubleIntHashMap newWithKeysValues(double key1, int value1, double key2, int value2) {
        return new DoubleIntHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static DoubleIntHashMap newWithKeysValues(double key1, int value1, double key2, int value2, double key3, int value3) {
        return new DoubleIntHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static DoubleIntHashMap newWithKeysValues(double key1, int value1, double key2, int value2, double key3, int value3, double key4, int value4) {
        return new DoubleIntHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleIntMap)) {
            return false;
        }
        DoubleIntMap other = (DoubleIntMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0) || other.containsKey(1.0)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0) || this.sentinelValues.zeroValue != other.getOrThrow(0.0))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0) || this.sentinelValues.oneValue != other.getOrThrow(1.0))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            double key = this.keys[i];
            if (!DoubleIntHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32) ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32) ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(Double.doubleToLongBits(this.keys[i]) ^ Double.doubleToLongBits(this.keys[i]) >>> 32) ^ this.values[i];
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0.0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1.0)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                double key = this.keys[i];
                if (!DoubleIntHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IntIterator intIterator() {
        return new InternalIntIterator();
    }

    public int[] toArray() {
        int[] array = new int[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(int value) {
        return this.containsValue(value);
    }

    public boolean containsAll(int ... source) {
        for (int each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        return source.allSatisfy(new IntPredicate(){

            public boolean accept(int value) {
                return DoubleIntHashMap.this.contains(value);
            }
        });
    }

    public void forEach(IntProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableIntCollection select(IntPredicate predicate) {
        IntArrayList result = new IntArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableIntCollection reject(IntPredicate predicate) {
        IntArrayList result = new IntArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public int detectIfNone(IntPredicate predicate, int value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(IntPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(IntPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectIntToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0.0);
        Arrays.fill(this.values, 0);
    }

    public void put(double key, int value) {
        if (DoubleIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (DoubleIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values[index] = value;
            return;
        }
        if (Double.compare(this.keys[index], 1.0) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(DoubleIntMap map) {
        map.forEachKeyValue(new DoubleIntProcedure(){

            public void value(double key, int value) {
                DoubleIntHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(double key) {
        if (DoubleIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (DoubleIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0;
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(double key) {
        this.removeKey(key);
    }

    public int removeKeyIfAbsent(double key, int value) {
        if (DoubleIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            int oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (DoubleIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            int oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0;
            int oldValue = this.values[index];
            this.values[index] = 0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public int getIfAbsentPut(double key, int value) {
        if (DoubleIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (DoubleIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public int getIfAbsentPut(double key, IntFunction0 function) {
        int value;
        if (DoubleIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (DoubleIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> int getIfAbsentPutWith(double key, IntFunction<? super P> function, P parameter) {
        int value;
        if (DoubleIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value2 = function.intValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value3 = function.intValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (DoubleIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value4 = function.intValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value5 = function.intValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.intValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public int getIfAbsentPutWithKey(double key, DoubleToIntFunction function) {
        int value;
        if (DoubleIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                int value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            int value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (DoubleIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                int value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            int value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public int updateValue(double key, int initialValueIfAbsent, IntToIntFunction function) {
        int value;
        if (DoubleIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (Double.compare(this.keys[index], 1.0) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public DoubleIntHashMap withKeyValue(double key1, int value1) {
        this.put(key1, value1);
        return this;
    }

    public DoubleIntHashMap withKeysValues(double key1, int value1, double key2, int value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public DoubleIntHashMap withKeysValues(double key1, int value1, double key2, int value2, double key3, int value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public DoubleIntHashMap withKeysValues(double key1, int value1, double key2, int value2, double key3, int value3, double key4, int value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public DoubleIntHashMap withoutKey(double key) {
        this.removeKey(key);
        return this;
    }

    public DoubleIntHashMap withoutAllKeys(DoubleIterable keys) {
        keys.forEach(new DoubleProcedure(){

            public void value(double key) {
                DoubleIntHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableDoubleIntMap asUnmodifiable() {
        return new UnmodifiableDoubleIntMap(this);
    }

    public MutableDoubleIntMap asSynchronized() {
        return new SynchronizedDoubleIntMap(this);
    }

    public ImmutableDoubleIntMap toImmutable() {
        return DoubleIntMaps.immutable.ofAll((DoubleIntMap)this);
    }

    public int get(double key) {
        return this.getIfAbsent(key, 0);
    }

    public int getIfAbsent(double key, int ifAbsent) {
        if (DoubleIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Double.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public int getOrThrow(double key) {
        if (DoubleIntHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (DoubleIntHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (DoubleIntHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(double key) {
        if (DoubleIntHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (DoubleIntHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Double.compare(this.keys[this.probe(key)], key) == 0;
    }

    public boolean containsValue(int value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i]) || this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0);
            }
        }
        for (double key : this.keys) {
            if (!DoubleIntHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(DoubleIntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyDoubleIterable keysView() {
        return new KeysView();
    }

    public DoubleIntHashMap select(DoubleIntPredicate predicate) {
        DoubleIntHashMap result = new DoubleIntHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public DoubleIntHashMap reject(DoubleIntPredicate predicate) {
        DoubleIntHashMap result = new DoubleIntHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0, this.sentinelValues.zeroValue)) {
                result.put(0.0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0, this.sentinelValues.oneValue)) {
                result.put(1.0, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public long sum() {
        long result = 0L;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (long)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (long)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i])) continue;
            result += (long)this.values[i];
        }
        return result;
    }

    public int max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        IntIterator iterator = this.intIterator();
        int max = iterator.next();
        while (iterator.hasNext()) {
            int value = iterator.next();
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public int maxIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public int min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        IntIterator iterator = this.intIterator();
        int min = iterator.next();
        while (iterator.hasNext()) {
            int value = iterator.next();
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public int minIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        int[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            int first = sortedArray[middleIndex];
            int second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public int[] toSortedArray() {
        int[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeDouble(0.0);
                out.writeInt(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeDouble(1.0);
                out.writeInt(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeDouble(this.keys[i]);
            out.writeInt(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readDouble(), in.readInt());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        double[] old = this.keys;
        int[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!DoubleIntHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(double element) {
        int index = this.spread(element);
        double keyAtIndex = this.keys[index];
        if (Double.compare(keyAtIndex, element) == 0 || Double.compare(keyAtIndex, 0.0) == 0) {
            return index;
        }
        int removedIndex = Double.compare(keyAtIndex, 1.0) == 0 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (Double.compare(this.keys[nextIndex &= this.keys.length - 1], element) == 0) {
                return nextIndex;
            }
            if (Double.compare(this.keys[nextIndex], 1.0) == 0) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (Double.compare(this.keys[nextIndex], 0.0) == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(double element) {
        long code = Double.doubleToLongBits(element);
        code = (code ^ 0xFFFFFFFFFFFFFFFFL) + (code << 18);
        code = (code << 18) - code - 1L;
        code ^= code >>> 31;
        code *= 21L;
        code += (code << 2) + (code << 4);
        code ^= code >>> 11;
        code += code << 6;
        code ^= code >>> 22;
        return (int)code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new double[sizeToAllocate];
        this.values = new int[sizeToAllocate];
    }

    private static boolean isEmptyKey(double key) {
        return Double.compare(key, 0.0) == 0;
    }

    private static boolean isRemovedKey(double key) {
        return Double.compare(key, 1.0) == 0;
    }

    private static boolean isNonSentinel(double key) {
        return !DoubleIntHashMap.isEmptyKey(key) && !DoubleIntHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableDoubleSet keySet() {
        return new KeySet();
    }

    public MutableIntCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableIntCollection {
        private ValuesCollection() {
        }

        public void clear() {
            DoubleIntHashMap.this.clear();
        }

        public MutableIntCollection select(IntPredicate predicate) {
            return DoubleIntHashMap.this.select(predicate);
        }

        public MutableIntCollection reject(IntPredicate predicate) {
            return DoubleIntHashMap.this.reject(predicate);
        }

        public int detectIfNone(IntPredicate predicate, int ifNone) {
            return DoubleIntHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(IntToObjectFunction<? extends V> function) {
            return DoubleIntHashMap.this.collect(function);
        }

        public long sum() {
            return DoubleIntHashMap.this.sum();
        }

        public int max() {
            return DoubleIntHashMap.this.max();
        }

        public int maxIfEmpty(int defaultValue) {
            return DoubleIntHashMap.this.maxIfEmpty(defaultValue);
        }

        public int min() {
            return DoubleIntHashMap.this.min();
        }

        public int minIfEmpty(int defaultValue) {
            return DoubleIntHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return DoubleIntHashMap.this.average();
        }

        public double median() {
            return DoubleIntHashMap.this.median();
        }

        public int[] toSortedArray() {
            return DoubleIntHashMap.this.toSortedArray();
        }

        public MutableIntList toSortedList() {
            return DoubleIntHashMap.this.toSortedList();
        }

        public MutableIntCollection with(int element) {
            throw new UnsupportedOperationException();
        }

        public MutableIntCollection without(int element) {
            throw new UnsupportedOperationException();
        }

        public MutableIntCollection withAll(IntIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableIntCollection withoutAll(IntIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableIntCollection asUnmodifiable() {
            return UnmodifiableIntCollection.of(this);
        }

        public MutableIntCollection asSynchronized() {
            return SynchronizedIntCollection.of(this);
        }

        public ImmutableIntCollection toImmutable() {
            return IntLists.immutable.withAll((IntIterable)this);
        }

        public boolean contains(int value) {
            return DoubleIntHashMap.this.containsValue(value);
        }

        public boolean containsAll(int ... source) {
            return DoubleIntHashMap.this.containsAll(source);
        }

        public boolean containsAll(IntIterable source) {
            return DoubleIntHashMap.this.containsAll(source);
        }

        public MutableIntList toList() {
            return DoubleIntHashMap.this.toList();
        }

        public MutableIntSet toSet() {
            return DoubleIntHashMap.this.toSet();
        }

        public MutableIntBag toBag() {
            return DoubleIntHashMap.this.toBag();
        }

        public LazyIntIterable asLazy() {
            return new LazyIntIterableAdapter((IntIterable)this);
        }

        public boolean isEmpty() {
            return DoubleIntHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleIntHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleIntHashMap.this.sentinelValues != null) {
                    if (DoubleIntHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(DoubleIntHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (DoubleIntHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(DoubleIntHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < DoubleIntHashMap.this.keys.length; ++i) {
                    double key = DoubleIntHashMap.this.keys[i];
                    if (!DoubleIntHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(DoubleIntHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public IntIterator intIterator() {
            return DoubleIntHashMap.this.intIterator();
        }

        public void forEach(IntProcedure procedure) {
            DoubleIntHashMap.this.forEach(procedure);
        }

        public int count(IntPredicate predicate) {
            return DoubleIntHashMap.this.count(predicate);
        }

        public boolean anySatisfy(IntPredicate predicate) {
            return DoubleIntHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(IntPredicate predicate) {
            return DoubleIntHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            return DoubleIntHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(int element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(IntIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(int item) {
            int oldSize = DoubleIntHashMap.this.size();
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && item == DoubleIntHashMap.this.sentinelValues.zeroValue) {
                    DoubleIntHashMap.this.removeKey(0.0);
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && item == DoubleIntHashMap.this.sentinelValues.oneValue) {
                    DoubleIntHashMap.this.removeKey(1.0);
                }
            }
            for (int i = 0; i < DoubleIntHashMap.this.keys.length; ++i) {
                if (!DoubleIntHashMap.isNonSentinel(DoubleIntHashMap.this.keys[i]) || item != DoubleIntHashMap.this.values[i]) continue;
                DoubleIntHashMap.this.removeKey(DoubleIntHashMap.this.keys[i]);
            }
            return oldSize != DoubleIntHashMap.this.size();
        }

        public boolean removeAll(IntIterable source) {
            int oldSize = DoubleIntHashMap.this.size();
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != DoubleIntHashMap.this.size();
        }

        public boolean removeAll(int ... source) {
            int oldSize = DoubleIntHashMap.this.size();
            for (int item : source) {
                this.remove(item);
            }
            return oldSize != DoubleIntHashMap.this.size();
        }

        public int size() {
            return DoubleIntHashMap.this.size();
        }

        public int[] toArray() {
            return DoubleIntHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableDoubleSet {
        private KeySet() {
        }

        public DoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        public void forEach(DoubleProcedure procedure) {
            DoubleIntHashMap.this.forEachKey(procedure);
        }

        public int count(DoublePredicate predicate) {
            int count = 0;
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    ++count;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    ++count;
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return true;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return true;
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(double element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(double ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(DoubleIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(double key) {
            int oldSize = DoubleIntHashMap.this.size();
            DoubleIntHashMap.this.removeKey(key);
            return oldSize != DoubleIntHashMap.this.size();
        }

        public boolean removeAll(DoubleIterable source) {
            int oldSize = DoubleIntHashMap.this.size();
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                DoubleIntHashMap.this.removeKey(iterator.next());
            }
            return oldSize != DoubleIntHashMap.this.size();
        }

        public boolean removeAll(double ... source) {
            int oldSize = DoubleIntHashMap.this.size();
            for (double item : source) {
                DoubleIntHashMap.this.removeKey(item);
            }
            return oldSize != DoubleIntHashMap.this.size();
        }

        public void clear() {
            DoubleIntHashMap.this.clear();
        }

        public MutableDoubleSet select(DoublePredicate predicate) {
            DoubleHashSet result = new DoubleHashSet();
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    result.add(0.0);
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    result.add(1.0);
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableDoubleSet reject(DoublePredicate predicate) {
            DoubleHashSet result = new DoubleHashSet();
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    result.add(0.0);
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    result.add(1.0);
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableDoubleSet with(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleSet without(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleSet withAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleSet withoutAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return 0.0;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return 1.0;
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(DoubleToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0.0));
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1.0));
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableDoubleSet asUnmodifiable() {
            return UnmodifiableDoubleSet.of(this);
        }

        public MutableDoubleSet asSynchronized() {
            return SynchronizedDoubleSet.of(this);
        }

        public double sum() {
            double sum = 0.0;
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0.0;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey) {
                    sum += 1.0;
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key)) continue;
                sum += key;
            }
            return sum;
        }

        public double max() {
            if (DoubleIntHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double max = 0.0;
            boolean isMaxSet = false;
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0.0;
                    isMaxSet = true;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || Double.compare(max, 1.0) < 0)) {
                    max = 1.0;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < DoubleIntHashMap.this.keys.length; ++i) {
                if (!DoubleIntHashMap.isNonSentinel(DoubleIntHashMap.this.keys[i]) || isMaxSet && Double.compare(max, DoubleIntHashMap.this.keys[i]) >= 0) continue;
                max = DoubleIntHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public double maxIfEmpty(double defaultValue) {
            if (DoubleIntHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double min() {
            if (DoubleIntHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            double min = 0.0;
            boolean isMinSet = false;
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0.0;
                    isMinSet = true;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && (!isMinSet || Double.compare(1.0, min) < 0)) {
                    min = 1.0;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < DoubleIntHashMap.this.keys.length; ++i) {
                if (!DoubleIntHashMap.isNonSentinel(DoubleIntHashMap.this.keys[i]) || isMinSet && Double.compare(DoubleIntHashMap.this.keys[i], min) >= 0) continue;
                min = DoubleIntHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public double minIfEmpty(double defaultValue) {
            if (DoubleIntHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            double[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                double first = sortedArray[middleIndex];
                double second = sortedArray[middleIndex - 1];
                return (first + second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public double[] toSortedArray() {
            double[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableDoubleList toSortedList() {
            return DoubleArrayList.newList((DoubleIterable)this).sortThis();
        }

        public double[] toArray() {
            int size = DoubleIntHashMap.this.size();
            final double[] result = new double[size];
            DoubleIntHashMap.this.forEachKey(new DoubleProcedure(){
                private int index;

                public void value(double each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(double value) {
            return DoubleIntHashMap.this.containsKey(value);
        }

        public boolean containsAll(double ... source) {
            for (double item : source) {
                if (DoubleIntHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(DoubleIterable source) {
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                if (DoubleIntHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableDoubleList toList() {
            return DoubleArrayList.newList((DoubleIterable)this);
        }

        public MutableDoubleSet toSet() {
            return DoubleHashSet.newSet((DoubleIterable)this);
        }

        public MutableDoubleBag toBag() {
            return DoubleHashBag.newBag((DoubleIterable)this);
        }

        public LazyDoubleIterable asLazy() {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }

        public DoubleSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableDoubleSet toImmutable() {
            return DoubleSets.immutable.withAll((DoubleIterable)this);
        }

        public int size() {
            return DoubleIntHashMap.this.size();
        }

        public boolean isEmpty() {
            return DoubleIntHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleIntHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DoubleSet)) {
                return false;
            }
            DoubleSet other = (DoubleSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey) {
                    result += (int)(Double.doubleToLongBits(0.0) ^ Double.doubleToLongBits(0.0) >>> 32);
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey) {
                    result += (int)(Double.doubleToLongBits(1.0) ^ Double.doubleToLongBits(1.0) >>> 32);
                }
            }
            for (int i = 0; i < DoubleIntHashMap.this.keys.length; ++i) {
                if (!DoubleIntHashMap.isNonSentinel(DoubleIntHashMap.this.keys[i])) continue;
                result += (int)(Double.doubleToLongBits(DoubleIntHashMap.this.keys[i]) ^ Double.doubleToLongBits(DoubleIntHashMap.this.keys[i]) >>> 32);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleIntHashMap.this.sentinelValues != null) {
                    if (DoubleIntHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0));
                        first = false;
                    }
                    if (DoubleIntHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0));
                        first = false;
                    }
                }
                for (double key : DoubleIntHashMap.this.keys) {
                    if (!DoubleIntHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements DoubleIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleIntHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleIntHashMap.this.containsKey(0.0)) {
                    return 0.0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleIntHashMap.this.containsKey(1.0)) {
                    return 1.0;
                }
            }
            double[] keys = DoubleIntHashMap.this.keys;
            while (!DoubleIntHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyDoubleIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return DoubleIntHashMap.this.size();
        }

        public boolean isEmpty() {
            return DoubleIntHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return DoubleIntHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (DoubleIntHashMap.this.sentinelValues != null) {
                    if (DoubleIntHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0));
                        first = false;
                    }
                    if (DoubleIntHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0));
                        first = false;
                    }
                }
                for (double key : DoubleIntHashMap.this.keys) {
                    if (!DoubleIntHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public DoubleIterator doubleIterator() {
            return new KeySetIterator();
        }

        public boolean contains(double key) {
            return DoubleIntHashMap.this.containsKey(key);
        }

        public boolean containsAll(double ... keys) {
            for (double key : keys) {
                if (DoubleIntHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(DoubleIterable source) {
            return source.allSatisfy(new DoublePredicate(){

                public boolean accept(double key) {
                    return DoubleIntHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(DoubleProcedure procedure) {
            DoubleIntHashMap.this.forEachKey(procedure);
        }

        public int count(DoublePredicate predicate) {
            int count = 0;
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    ++count;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    ++count;
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return true;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return true;
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return false;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return false;
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyDoubleIterable select(DoublePredicate predicate) {
            return new SelectDoubleIterable((DoubleIterable)this, predicate);
        }

        public LazyDoubleIterable reject(DoublePredicate predicate) {
            return new SelectDoubleIterable((DoubleIterable)this, DoublePredicates.not(predicate));
        }

        public double detectIfNone(DoublePredicate predicate, double value) {
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0)) {
                    return 0.0;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0)) {
                    return 1.0;
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(DoubleToObjectFunction<? extends V> function) {
            return new CollectDoubleToObjectIterable<V>((DoubleIterable)this, function);
        }

        public double sum() {
            double result = 0.0;
            if (DoubleIntHashMap.this.sentinelValues != null) {
                if (DoubleIntHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0.0;
                }
                if (DoubleIntHashMap.this.sentinelValues.containsOneKey) {
                    result += 1.0;
                }
            }
            for (double key : DoubleIntHashMap.this.keys) {
                if (!DoubleIntHashMap.isNonSentinel(key)) continue;
                result += key;
            }
            return result;
        }

        public double max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            DoubleIterator iterator = this.doubleIterator();
            double max = iterator.next();
            while (iterator.hasNext()) {
                double value = iterator.next();
                if (Double.compare(max, value) >= 0) continue;
                max = value;
            }
            return max;
        }

        public double min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            DoubleIterator iterator = this.doubleIterator();
            double min = iterator.next();
            while (iterator.hasNext()) {
                double value = iterator.next();
                if (Double.compare(value, min) >= 0) continue;
                min = value;
            }
            return min;
        }

        public double minIfEmpty(double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double maxIfEmpty(double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            double[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                double first = sortedArray[middleIndex];
                double second = sortedArray[middleIndex - 1];
                return (first + second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public double[] toSortedArray() {
            double[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public double[] toArray() {
            int size = DoubleIntHashMap.this.size();
            final double[] result = new double[size];
            DoubleIntHashMap.this.forEachKey(new DoubleProcedure(){
                private int index;

                public void value(double each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public MutableDoubleList toList() {
            return DoubleArrayList.newList((DoubleIterable)this);
        }

        public MutableDoubleList toSortedList() {
            return DoubleArrayList.newList((DoubleIterable)this).sortThis();
        }

        public MutableDoubleSet toSet() {
            return DoubleHashSet.newSet((DoubleIterable)this);
        }

        public MutableDoubleBag toBag() {
            return DoubleHashBag.newBag((DoubleIterable)this);
        }

        public LazyDoubleIterable asLazy() {
            return this;
        }
    }

    private class InternalIntIterator
    implements IntIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalIntIterator() {
        }

        public boolean hasNext() {
            return this.count < DoubleIntHashMap.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (DoubleIntHashMap.this.containsKey(0.0)) {
                    return DoubleIntHashMap.this.get(0.0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (DoubleIntHashMap.this.containsKey(1.0)) {
                    return DoubleIntHashMap.this.get(1.0);
                }
            }
            double[] keys = DoubleIntHashMap.this.keys;
            while (!DoubleIntHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            int result = DoubleIntHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private int zeroValue;
        private int oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(int value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && this.zeroValue == value;
            boolean valueEqualsOneValue = this.containsOneKey && this.oneValue == value;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

