/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction0;
import com.gs.collections.api.block.function.primitive.DoubleToDoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.FloatToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.FloatDoublePredicate;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatDoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.map.primitive.FloatDoubleMap;
import com.gs.collections.api.map.primitive.ImmutableFloatDoubleMap;
import com.gs.collections.api.map.primitive.MutableFloatDoubleMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.block.factory.primitive.FloatPredicates;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedDoubleCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.factory.primitive.FloatDoubleMaps;
import com.gs.collections.impl.factory.primitive.FloatSets;
import com.gs.collections.impl.lazy.primitive.CollectFloatToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectFloatIterable;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedFloatDoubleMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableFloatDoubleMap;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedFloatSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatDoubleHashMap
implements MutableFloatDoubleMap,
Externalizable {
    static final double EMPTY_VALUE = 0.0;
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_KEY = 0.0f;
    private static final float REMOVED_KEY = 1.0f;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private float[] keys;
    private double[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public FloatDoubleHashMap() {
        this.allocateTable(16);
    }

    public FloatDoubleHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public FloatDoubleHashMap(FloatDoubleMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static FloatDoubleHashMap newWithKeysValues(float key1, double value1) {
        return new FloatDoubleHashMap(1).withKeyValue(key1, value1);
    }

    public static FloatDoubleHashMap newWithKeysValues(float key1, double value1, float key2, double value2) {
        return new FloatDoubleHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static FloatDoubleHashMap newWithKeysValues(float key1, double value1, float key2, double value2, float key3, double value3) {
        return new FloatDoubleHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static FloatDoubleHashMap newWithKeysValues(float key1, double value1, float key2, double value2, float key3, double value3, float key4, double value4) {
        return new FloatDoubleHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatDoubleMap)) {
            return false;
        }
        FloatDoubleMap other = (FloatDoubleMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0.0f) || other.containsKey(1.0f)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0.0f) || Double.compare(this.sentinelValues.zeroValue, other.getOrThrow(0.0f)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1.0f) || Double.compare(this.sentinelValues.oneValue, other.getOrThrow(1.0f)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            float key = this.keys[i];
            if (!FloatDoubleHashMap.isNonSentinel(key) || other.containsKey(key) && Double.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += Float.floatToIntBits(0.0f) ^ (int)(Double.doubleToLongBits(this.sentinelValues.zeroValue) ^ Double.doubleToLongBits(this.sentinelValues.zeroValue) >>> 32);
            }
            if (this.sentinelValues.containsOneKey) {
                result += Float.floatToIntBits(1.0f) ^ (int)(Double.doubleToLongBits(this.sentinelValues.oneValue) ^ Double.doubleToLongBits(this.sentinelValues.oneValue) >>> 32);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += Float.floatToIntBits(this.keys[i]) ^ (int)(Double.doubleToLongBits(this.values[i]) ^ Double.doubleToLongBits(this.values[i]) >>> 32);
        }
        return result;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(0.0f)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(1.0f)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                float key = this.keys[i];
                if (!FloatDoubleHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DoubleIterator doubleIterator() {
        return new InternalDoubleIterator();
    }

    public double[] toArray() {
        double[] array = new double[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(double value) {
        return this.containsValue(value);
    }

    public boolean containsAll(double ... source) {
        for (double each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.allSatisfy(new DoublePredicate(){

            public boolean accept(double value) {
                return FloatDoubleHashMap.this.contains(value);
            }
        });
    }

    public void forEach(DoubleProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableDoubleCollection select(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableDoubleCollection reject(DoublePredicate predicate) {
        DoubleArrayList result = new DoubleArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public double detectIfNone(DoublePredicate predicate, double value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(DoublePredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectDoubleToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newList((DoubleIterable)this);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet((DoubleIterable)this);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag((DoubleIterable)this);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0.0f);
        Arrays.fill(this.values, 0.0);
    }

    public void put(float key, double value) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.values[index] = value;
            return;
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    public void putAll(FloatDoubleMap map) {
        map.forEachKeyValue(new FloatDoubleProcedure(){

            public void value(float key, double value) {
                FloatDoubleHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(float key) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0f;
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(float key) {
        this.removeKey(key);
    }

    public double removeKeyIfAbsent(float key, double value) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            double oldValue = this.sentinelValues.zeroValue;
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.containsZeroKey = false;
                this.sentinelValues.zeroValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            double oldValue = this.sentinelValues.oneValue;
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.containsOneKey = false;
                this.sentinelValues.oneValue = 0.0;
            } else {
                this.sentinelValues = null;
            }
            return oldValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.keys[index] = 1.0f;
            double oldValue = this.values[index];
            this.values[index] = 0.0;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public double getIfAbsentPut(float key, double value) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value;
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value;
            return value;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value;
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value;
            return value;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public double getIfAbsentPut(float key, DoubleFunction0 function) {
        double value;
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value2 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value3 = function.value();
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value4 = function.value();
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value5 = function.value();
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.value();
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public <P> double getIfAbsentPutWith(float key, DoubleFunction<? super P> function, P parameter) {
        double value;
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value2 = function.doubleValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value3 = function.doubleValueOf(parameter);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value4 = function.doubleValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value5 = function.doubleValueOf(parameter);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.doubleValueOf(parameter);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public double getIfAbsentPutWithKey(float key, FloatToDoubleFunction function) {
        double value;
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                double value2 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = value2;
                return value2;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            double value3 = function.valueOf(key);
            this.sentinelValues.containsZeroKey = true;
            this.sentinelValues.zeroValue = value3;
            return value3;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                double value4 = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = value4;
                return value4;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            double value5 = function.valueOf(key);
            this.sentinelValues.containsOneKey = true;
            this.sentinelValues.oneValue = value5;
            return value5;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(key);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public double updateValue(float key, double initialValueIfAbsent, DoubleToDoubleFunction function) {
        double value;
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.sentinelValues.containsZeroKey = true;
                this.sentinelValues.zeroValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.sentinelValues.containsOneKey = true;
                this.sentinelValues.oneValue = function.valueOf(initialValueIfAbsent);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        if (Float.compare(this.keys[index], 1.0f) == 0) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value = function.valueOf(initialValueIfAbsent);
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
        return value;
    }

    public FloatDoubleHashMap withKeyValue(float key1, double value1) {
        this.put(key1, value1);
        return this;
    }

    public FloatDoubleHashMap withKeysValues(float key1, double value1, float key2, double value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public FloatDoubleHashMap withKeysValues(float key1, double value1, float key2, double value2, float key3, double value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public FloatDoubleHashMap withKeysValues(float key1, double value1, float key2, double value2, float key3, double value3, float key4, double value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public FloatDoubleHashMap withoutKey(float key) {
        this.removeKey(key);
        return this;
    }

    public FloatDoubleHashMap withoutAllKeys(FloatIterable keys) {
        keys.forEach(new FloatProcedure(){

            public void value(float key) {
                FloatDoubleHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableFloatDoubleMap asUnmodifiable() {
        return new UnmodifiableFloatDoubleMap(this);
    }

    public MutableFloatDoubleMap asSynchronized() {
        return new SynchronizedFloatDoubleMap(this);
    }

    public ImmutableFloatDoubleMap toImmutable() {
        return FloatDoubleMaps.immutable.ofAll((FloatDoubleMap)this);
    }

    public double get(float key) {
        return this.getIfAbsent(key, 0.0);
    }

    public double getIfAbsent(float key, double ifAbsent) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (Float.compare(this.keys[index], key) == 0) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public double getOrThrow(float key) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (FloatDoubleHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key) {
        if (FloatDoubleHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (FloatDoubleHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return Float.compare(this.keys[this.probe(key)], key) == 0;
    }

    public boolean containsValue(double value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i]) || Double.compare(this.values[i], value) != 0) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(DoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(FloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f);
            }
        }
        for (float key : this.keys) {
            if (!FloatDoubleHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(FloatDoubleProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyFloatIterable keysView() {
        return new KeysView();
    }

    public FloatDoubleHashMap select(FloatDoublePredicate predicate) {
        FloatDoubleHashMap result = new FloatDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public FloatDoubleHashMap reject(FloatDoublePredicate predicate) {
        FloatDoubleHashMap result = new FloatDoubleHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0.0f, this.sentinelValues.zeroValue)) {
                result.put(0.0f, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1.0f, this.sentinelValues.oneValue)) {
                result.put(1.0f, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public double sum() {
        double result = 0.0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.values[i];
        }
        return result;
    }

    public double max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        DoubleIterator iterator = this.doubleIterator();
        double max = iterator.next();
        while (iterator.hasNext()) {
            double value = iterator.next();
            if (Double.compare(max, value) >= 0) continue;
            max = value;
        }
        return max;
    }

    public double maxIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        DoubleIterator iterator = this.doubleIterator();
        double min = iterator.next();
        while (iterator.hasNext()) {
            double value = iterator.next();
            if (Double.compare(value, min) >= 0) continue;
            min = value;
        }
        return min;
    }

    public double minIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        double[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            double first = sortedArray[middleIndex];
            double second = sortedArray[middleIndex - 1];
            return (first + second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public double[] toSortedArray() {
        double[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableDoubleList toSortedList() {
        return DoubleArrayList.newList((DoubleIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeFloat(0.0f);
                out.writeDouble(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeFloat(1.0f);
                out.writeDouble(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeFloat(this.keys[i]);
            out.writeDouble(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readFloat(), in.readDouble());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        float[] old = this.keys;
        double[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!FloatDoubleHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(float element) {
        int index = this.spread(element);
        float keyAtIndex = this.keys[index];
        if (Float.compare(keyAtIndex, element) == 0 || Float.compare(keyAtIndex, 0.0f) == 0) {
            return index;
        }
        int removedIndex = Float.compare(keyAtIndex, 1.0f) == 0 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (Float.compare(this.keys[nextIndex &= this.keys.length - 1], element) == 0) {
                return nextIndex;
            }
            if (Float.compare(this.keys[nextIndex], 1.0f) == 0) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (Float.compare(this.keys[nextIndex], 0.0f) == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(float element) {
        int code = Float.floatToIntBits(element);
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new float[sizeToAllocate];
        this.values = new double[sizeToAllocate];
    }

    private static boolean isEmptyKey(float key) {
        return Float.compare(key, 0.0f) == 0;
    }

    private static boolean isRemovedKey(float key) {
        return Float.compare(key, 1.0f) == 0;
    }

    private static boolean isNonSentinel(float key) {
        return !FloatDoubleHashMap.isEmptyKey(key) && !FloatDoubleHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableFloatSet keySet() {
        return new KeySet();
    }

    public MutableDoubleCollection values() {
        return new ValuesCollection();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableDoubleCollection {
        private ValuesCollection() {
        }

        public void clear() {
            FloatDoubleHashMap.this.clear();
        }

        public MutableDoubleCollection select(DoublePredicate predicate) {
            return FloatDoubleHashMap.this.select(predicate);
        }

        public MutableDoubleCollection reject(DoublePredicate predicate) {
            return FloatDoubleHashMap.this.reject(predicate);
        }

        public double detectIfNone(DoublePredicate predicate, double ifNone) {
            return FloatDoubleHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(DoubleToObjectFunction<? extends V> function) {
            return FloatDoubleHashMap.this.collect(function);
        }

        public double sum() {
            return FloatDoubleHashMap.this.sum();
        }

        public double max() {
            return FloatDoubleHashMap.this.max();
        }

        public double maxIfEmpty(double defaultValue) {
            return FloatDoubleHashMap.this.maxIfEmpty(defaultValue);
        }

        public double min() {
            return FloatDoubleHashMap.this.min();
        }

        public double minIfEmpty(double defaultValue) {
            return FloatDoubleHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return FloatDoubleHashMap.this.average();
        }

        public double median() {
            return FloatDoubleHashMap.this.median();
        }

        public double[] toSortedArray() {
            return FloatDoubleHashMap.this.toSortedArray();
        }

        public MutableDoubleList toSortedList() {
            return FloatDoubleHashMap.this.toSortedList();
        }

        public MutableDoubleCollection with(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection without(double element) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection withAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection withoutAll(DoubleIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableDoubleCollection asUnmodifiable() {
            return UnmodifiableDoubleCollection.of(this);
        }

        public MutableDoubleCollection asSynchronized() {
            return SynchronizedDoubleCollection.of(this);
        }

        public ImmutableDoubleCollection toImmutable() {
            return DoubleLists.immutable.withAll((DoubleIterable)this);
        }

        public boolean contains(double value) {
            return FloatDoubleHashMap.this.containsValue(value);
        }

        public boolean containsAll(double ... source) {
            return FloatDoubleHashMap.this.containsAll(source);
        }

        public boolean containsAll(DoubleIterable source) {
            return FloatDoubleHashMap.this.containsAll(source);
        }

        public MutableDoubleList toList() {
            return FloatDoubleHashMap.this.toList();
        }

        public MutableDoubleSet toSet() {
            return FloatDoubleHashMap.this.toSet();
        }

        public MutableDoubleBag toBag() {
            return FloatDoubleHashMap.this.toBag();
        }

        public LazyDoubleIterable asLazy() {
            return new LazyDoubleIterableAdapter((DoubleIterable)this);
        }

        public boolean isEmpty() {
            return FloatDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatDoubleHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatDoubleHashMap.this.sentinelValues != null) {
                    if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(FloatDoubleHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (FloatDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(FloatDoubleHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < FloatDoubleHashMap.this.keys.length; ++i) {
                    float key = FloatDoubleHashMap.this.keys[i];
                    if (!FloatDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(FloatDoubleHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public DoubleIterator doubleIterator() {
            return FloatDoubleHashMap.this.doubleIterator();
        }

        public void forEach(DoubleProcedure procedure) {
            FloatDoubleHashMap.this.forEach(procedure);
        }

        public int count(DoublePredicate predicate) {
            return FloatDoubleHashMap.this.count(predicate);
        }

        public boolean anySatisfy(DoublePredicate predicate) {
            return FloatDoubleHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(DoublePredicate predicate) {
            return FloatDoubleHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(DoublePredicate predicate) {
            return FloatDoubleHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(double element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(double ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(DoubleIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(double item) {
            int oldSize = FloatDoubleHashMap.this.size();
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && Double.compare(item, FloatDoubleHashMap.this.sentinelValues.zeroValue) == 0) {
                    FloatDoubleHashMap.this.removeKey(0.0f);
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && Double.compare(item, FloatDoubleHashMap.this.sentinelValues.oneValue) == 0) {
                    FloatDoubleHashMap.this.removeKey(1.0f);
                }
            }
            for (int i = 0; i < FloatDoubleHashMap.this.keys.length; ++i) {
                if (!FloatDoubleHashMap.isNonSentinel(FloatDoubleHashMap.this.keys[i]) || Double.compare(item, FloatDoubleHashMap.this.values[i]) != 0) continue;
                FloatDoubleHashMap.this.removeKey(FloatDoubleHashMap.this.keys[i]);
            }
            return oldSize != FloatDoubleHashMap.this.size();
        }

        public boolean removeAll(DoubleIterable source) {
            int oldSize = FloatDoubleHashMap.this.size();
            DoubleIterator iterator = source.doubleIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != FloatDoubleHashMap.this.size();
        }

        public boolean removeAll(double ... source) {
            int oldSize = FloatDoubleHashMap.this.size();
            for (double item : source) {
                this.remove(item);
            }
            return oldSize != FloatDoubleHashMap.this.size();
        }

        public int size() {
            return FloatDoubleHashMap.this.size();
        }

        public double[] toArray() {
            return FloatDoubleHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableFloatSet {
        private KeySet() {
        }

        public FloatIterator floatIterator() {
            return new KeySetIterator();
        }

        public void forEach(FloatProcedure procedure) {
            FloatDoubleHashMap.this.forEachKey(procedure);
        }

        public int count(FloatPredicate predicate) {
            int count = 0;
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    ++count;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    ++count;
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return true;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return true;
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(float element) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(float ... source) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(FloatIterable source) {
            throw new UnsupportedOperationException();
        }

        public boolean remove(float key) {
            int oldSize = FloatDoubleHashMap.this.size();
            FloatDoubleHashMap.this.removeKey(key);
            return oldSize != FloatDoubleHashMap.this.size();
        }

        public boolean removeAll(FloatIterable source) {
            int oldSize = FloatDoubleHashMap.this.size();
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                FloatDoubleHashMap.this.removeKey(iterator.next());
            }
            return oldSize != FloatDoubleHashMap.this.size();
        }

        public boolean removeAll(float ... source) {
            int oldSize = FloatDoubleHashMap.this.size();
            for (float item : source) {
                FloatDoubleHashMap.this.removeKey(item);
            }
            return oldSize != FloatDoubleHashMap.this.size();
        }

        public void clear() {
            FloatDoubleHashMap.this.clear();
        }

        public MutableFloatSet select(FloatPredicate predicate) {
            FloatHashSet result = new FloatHashSet();
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    result.add(0.0f);
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    result.add(1.0f);
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableFloatSet reject(FloatPredicate predicate) {
            FloatHashSet result = new FloatHashSet();
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    result.add(0.0f);
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    result.add(1.0f);
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableFloatSet with(float element) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatSet without(float element) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatSet withAll(FloatIterable elements) {
            throw new UnsupportedOperationException();
        }

        public MutableFloatSet withoutAll(FloatIterable elements) {
            throw new UnsupportedOperationException();
        }

        public float detectIfNone(FloatPredicate predicate, float ifNone) {
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return 0.0f;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return 1.0f;
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0.0f));
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1.0f));
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableFloatSet asUnmodifiable() {
            return UnmodifiableFloatSet.of(this);
        }

        public MutableFloatSet asSynchronized() {
            return SynchronizedFloatSet.of(this);
        }

        public double sum() {
            double sum = 0.0;
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0.0;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey) {
                    sum += 1.0;
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key)) continue;
                sum += (double)key;
            }
            return sum;
        }

        public float max() {
            if (FloatDoubleHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float max = 0.0f;
            boolean isMaxSet = false;
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0.0f;
                    isMaxSet = true;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || Float.compare(max, 1.0f) < 0)) {
                    max = 1.0f;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < FloatDoubleHashMap.this.keys.length; ++i) {
                if (!FloatDoubleHashMap.isNonSentinel(FloatDoubleHashMap.this.keys[i]) || isMaxSet && Float.compare(max, FloatDoubleHashMap.this.keys[i]) >= 0) continue;
                max = FloatDoubleHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public float maxIfEmpty(float defaultValue) {
            if (FloatDoubleHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public float min() {
            if (FloatDoubleHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            float min = 0.0f;
            boolean isMinSet = false;
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0.0f;
                    isMinSet = true;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && (!isMinSet || Float.compare(1.0f, min) < 0)) {
                    min = 1.0f;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < FloatDoubleHashMap.this.keys.length; ++i) {
                if (!FloatDoubleHashMap.isNonSentinel(FloatDoubleHashMap.this.keys[i]) || isMinSet && Float.compare(FloatDoubleHashMap.this.keys[i], min) >= 0) continue;
                min = FloatDoubleHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public float minIfEmpty(float defaultValue) {
            if (FloatDoubleHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            float[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                float first = sortedArray[middleIndex];
                float second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public float[] toSortedArray() {
            float[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableFloatList toSortedList() {
            return FloatArrayList.newList((FloatIterable)this).sortThis();
        }

        public float[] toArray() {
            int size = FloatDoubleHashMap.this.size();
            final float[] result = new float[size];
            FloatDoubleHashMap.this.forEachKey(new FloatProcedure(){
                private int index;

                public void value(float each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(float value) {
            return FloatDoubleHashMap.this.containsKey(value);
        }

        public boolean containsAll(float ... source) {
            for (float item : source) {
                if (FloatDoubleHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(FloatIterable source) {
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                if (FloatDoubleHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableFloatList toList() {
            return FloatArrayList.newList((FloatIterable)this);
        }

        public MutableFloatSet toSet() {
            return FloatHashSet.newSet((FloatIterable)this);
        }

        public MutableFloatBag toBag() {
            return FloatHashBag.newBag((FloatIterable)this);
        }

        public LazyFloatIterable asLazy() {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }

        public FloatSet freeze() {
            throw new UnsupportedOperationException();
        }

        public ImmutableFloatSet toImmutable() {
            return FloatSets.immutable.withAll((FloatIterable)this);
        }

        public int size() {
            return FloatDoubleHashMap.this.size();
        }

        public boolean isEmpty() {
            return FloatDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatDoubleHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof FloatSet)) {
                return false;
            }
            FloatSet other = (FloatSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result += Float.floatToIntBits(0.0f);
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result += Float.floatToIntBits(1.0f);
                }
            }
            for (int i = 0; i < FloatDoubleHashMap.this.keys.length; ++i) {
                if (!FloatDoubleHashMap.isNonSentinel(FloatDoubleHashMap.this.keys[i])) continue;
                result += Float.floatToIntBits(FloatDoubleHashMap.this.keys[i]);
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatDoubleHashMap.this.sentinelValues != null) {
                    if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0f));
                        first = false;
                    }
                    if (FloatDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0f));
                        first = false;
                    }
                }
                for (float key : FloatDoubleHashMap.this.keys) {
                    if (!FloatDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements FloatIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatDoubleHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatDoubleHashMap.this.containsKey(0.0f)) {
                    return 0.0f;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatDoubleHashMap.this.containsKey(1.0f)) {
                    return 1.0f;
                }
            }
            float[] keys = FloatDoubleHashMap.this.keys;
            while (!FloatDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            float result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeysView
    implements LazyFloatIterable {
        private KeysView() {
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public int size() {
            return FloatDoubleHashMap.this.size();
        }

        public boolean isEmpty() {
            return FloatDoubleHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return FloatDoubleHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (FloatDoubleHashMap.this.sentinelValues != null) {
                    if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0.0f));
                        first = false;
                    }
                    if (FloatDoubleHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1.0f));
                        first = false;
                    }
                }
                for (float key : FloatDoubleHashMap.this.keys) {
                    if (!FloatDoubleHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FloatIterator floatIterator() {
            return new KeySetIterator();
        }

        public boolean contains(float key) {
            return FloatDoubleHashMap.this.containsKey(key);
        }

        public boolean containsAll(float ... keys) {
            for (float key : keys) {
                if (FloatDoubleHashMap.this.containsKey(key)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(FloatIterable source) {
            return source.allSatisfy(new FloatPredicate(){

                public boolean accept(float key) {
                    return FloatDoubleHashMap.this.containsKey(key);
                }
            });
        }

        public void forEach(FloatProcedure procedure) {
            FloatDoubleHashMap.this.forEachKey(procedure);
        }

        public int count(FloatPredicate predicate) {
            int count = 0;
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    ++count;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    ++count;
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return true;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return true;
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return false;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return false;
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public LazyFloatIterable select(FloatPredicate predicate) {
            return new SelectFloatIterable((FloatIterable)this, predicate);
        }

        public LazyFloatIterable reject(FloatPredicate predicate) {
            return new SelectFloatIterable((FloatIterable)this, FloatPredicates.not(predicate));
        }

        public float detectIfNone(FloatPredicate predicate, float value) {
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0.0f)) {
                    return 0.0f;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey && predicate.accept(1.0f)) {
                    return 1.0f;
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return value;
        }

        public <V> LazyIterable<V> collect(FloatToObjectFunction<? extends V> function) {
            return new CollectFloatToObjectIterable<V>((FloatIterable)this, function);
        }

        public double sum() {
            double result = 0.0;
            if (FloatDoubleHashMap.this.sentinelValues != null) {
                if (FloatDoubleHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0.0;
                }
                if (FloatDoubleHashMap.this.sentinelValues.containsOneKey) {
                    result += 1.0;
                }
            }
            for (float key : FloatDoubleHashMap.this.keys) {
                if (!FloatDoubleHashMap.isNonSentinel(key)) continue;
                result += (double)key;
            }
            return result;
        }

        public float max() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            FloatIterator iterator = this.floatIterator();
            float max = iterator.next();
            while (iterator.hasNext()) {
                float value = iterator.next();
                if (Float.compare(max, value) >= 0) continue;
                max = value;
            }
            return max;
        }

        public float min() {
            if (this.isEmpty()) {
                throw new NoSuchElementException();
            }
            FloatIterator iterator = this.floatIterator();
            float min = iterator.next();
            while (iterator.hasNext()) {
                float value = iterator.next();
                if (Float.compare(value, min) >= 0) continue;
                min = value;
            }
            return min;
        }

        public float minIfEmpty(float defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public float maxIfEmpty(float defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            float[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                float first = sortedArray[middleIndex];
                float second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public float[] toSortedArray() {
            float[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public float[] toArray() {
            int size = FloatDoubleHashMap.this.size();
            final float[] result = new float[size];
            FloatDoubleHashMap.this.forEachKey(new FloatProcedure(){
                private int index;

                public void value(float each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public MutableFloatList toList() {
            return FloatArrayList.newList((FloatIterable)this);
        }

        public MutableFloatList toSortedList() {
            return FloatArrayList.newList((FloatIterable)this).sortThis();
        }

        public MutableFloatSet toSet() {
            return FloatHashSet.newSet((FloatIterable)this);
        }

        public MutableFloatBag toBag() {
            return FloatHashBag.newBag((FloatIterable)this);
        }

        public LazyFloatIterable asLazy() {
            return this;
        }
    }

    private class InternalDoubleIterator
    implements DoubleIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalDoubleIterator() {
        }

        public boolean hasNext() {
            return this.count < FloatDoubleHashMap.this.size();
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (FloatDoubleHashMap.this.containsKey(0.0f)) {
                    return FloatDoubleHashMap.this.get(0.0f);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (FloatDoubleHashMap.this.containsKey(1.0f)) {
                    return FloatDoubleHashMap.this.get(1.0f);
                }
            }
            float[] keys = FloatDoubleHashMap.this.keys;
            while (!FloatDoubleHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            double result = FloatDoubleHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private double zeroValue;
        private double oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(double value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && Double.compare(this.zeroValue, value) == 0;
            boolean valueEqualsOneValue = this.containsOneKey && Double.compare(this.oneValue, value) == 0;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

