/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LongIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.IntToLongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongFunction0;
import com.gs.collections.api.block.function.primitive.LongToLongFunction;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntLongPredicate;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.IntLongProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableLongCollection;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.map.primitive.ImmutableIntLongMap;
import com.gs.collections.api.map.primitive.IntLongMap;
import com.gs.collections.api.map.primitive.MutableIntLongMap;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.factory.primitive.IntLongMaps;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedIntLongMap;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableIntLongMap
implements MutableIntLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntLongMap map;

    UnmodifiableIntLongMap(MutableIntLongMap map) {
        this.map = map;
    }

    private boolean isAbsent(long result, int key) {
        return result == 0L && !this.containsKey(key);
    }

    private long getIfAbsentThrow(int key) {
        long result = this.map.get(key);
        if (this.isAbsent(result, key)) {
            throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
        }
        return result;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(int key, long value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(IntLongMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(int key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(int key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public long removeKeyIfAbsent(int key, long value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public long getIfAbsentPut(int key, long value) {
        return this.getIfAbsentThrow(key);
    }

    public long getIfAbsentPut(int key, LongFunction0 function) {
        return this.getIfAbsentThrow(key);
    }

    public long getIfAbsentPutWithKey(int key, IntToLongFunction function) {
        return this.getIfAbsentThrow(key);
    }

    public <P> long getIfAbsentPutWith(int key, LongFunction<? super P> function, P parameter) {
        return this.getIfAbsentThrow(key);
    }

    public long updateValue(int key, long initialValueIfAbsent, LongToLongFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public long get(int key) {
        return this.map.get(key);
    }

    public long getIfAbsent(int key, long ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public long getOrThrow(int key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(int key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(long value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(LongProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(IntProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(IntLongProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyIntIterable keysView() {
        return this.map.keysView();
    }

    public MutableIntLongMap select(IntLongPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableIntLongMap reject(IntLongPredicate predicate) {
        return this.map.reject(predicate);
    }

    public LongIterator longIterator() {
        return this.map.longIterator();
    }

    public void forEach(LongProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(LongPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableLongCollection select(LongPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableLongCollection reject(LongPredicate predicate) {
        return this.map.reject(predicate);
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public long sum() {
        return this.map.sum();
    }

    public long max() {
        return this.map.max();
    }

    public long maxIfEmpty(long defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public long min() {
        return this.map.min();
    }

    public long minIfEmpty(long defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public long[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableLongList toSortedList() {
        return this.map.toSortedList();
    }

    public long[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(long value) {
        return this.map.contains(value);
    }

    public boolean containsAll(long ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(LongIterable source) {
        return this.map.containsAll(source);
    }

    public MutableLongList toList() {
        return this.map.toList();
    }

    public MutableLongSet toSet() {
        return this.map.toSet();
    }

    public MutableLongBag toBag() {
        return this.map.toBag();
    }

    public LazyLongIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableIntLongMap withKeyValue(int key, long value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableIntLongMap withoutKey(int key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableIntLongMap withoutAllKeys(IntIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableIntLongMap asUnmodifiable() {
        return this;
    }

    public MutableIntLongMap asSynchronized() {
        return new SynchronizedIntLongMap(this);
    }

    public ImmutableIntLongMap toImmutable() {
        return IntLongMaps.immutable.withAll((IntLongMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableIntSet keySet() {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableLongCollection values() {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }
}

