/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.partition.stack;

import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.partition.stack.PartitionImmutableStack;
import com.gs.collections.api.partition.stack.PartitionMutableStack;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.partition.stack.PartitionImmutableStackImpl;
import com.gs.collections.impl.stack.mutable.ArrayStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionArrayStack<T>
implements PartitionMutableStack<T> {
    private final MutableList<T> selected = FastList.newList();
    private final MutableList<T> rejected = FastList.newList();
    private final Predicate<? super T> predicate;

    public PartitionArrayStack(Predicate<? super T> predicate) {
        this.predicate = predicate;
    }

    public MutableStack<T> getSelected() {
        return ArrayStack.newStackFromTopToBottom(this.selected);
    }

    public MutableStack<T> getRejected() {
        return ArrayStack.newStackFromTopToBottom(this.rejected);
    }

    public PartitionImmutableStack<T> toImmutable() {
        return new PartitionImmutableStackImpl(this);
    }

    public void add(T t) {
        (this.predicate.accept(t) ? this.selected : this.rejected).add(t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PartitionProcedure<T>
    implements Procedure<T> {
        private static final long serialVersionUID = 1L;
        private final Predicate<? super T> predicate;
        private final PartitionArrayStack<T> partitionMutableStack;

        public PartitionProcedure(Predicate<? super T> predicate, PartitionArrayStack<T> partitionMutableStack) {
            this.predicate = predicate;
            this.partitionMutableStack = partitionMutableStack;
        }

        public void value(T each) {
            MutableList bucket = this.predicate.accept(each) ? ((PartitionArrayStack)this.partitionMutableStack).selected : ((PartitionArrayStack)this.partitionMutableStack).rejected;
            bucket.add(each);
        }
    }
}

