/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.IntList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.stack.primitive.ImmutableIntStack;
import com.gs.collections.api.stack.primitive.IntStack;
import com.gs.collections.api.stack.primitive.MutableIntStack;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.primitive.IntStacks;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.stack.mutable.ArrayStack;
import com.gs.collections.impl.stack.mutable.primitive.SynchronizedIntStack;
import com.gs.collections.impl.stack.mutable.primitive.UnmodifiableIntStack;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.EmptyStackException;
import net.jcip.annotations.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public final class IntArrayStack
implements MutableIntStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient IntArrayList delegate;

    public IntArrayStack() {
        this.delegate = new IntArrayList();
    }

    private IntArrayStack(int size) {
        this.delegate = new IntArrayList(size);
    }

    private IntArrayStack(int ... items) {
        this.delegate = new IntArrayList(items);
    }

    public static IntArrayStack newStackFromTopToBottom(int ... items) {
        IntArrayStack stack = new IntArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static IntArrayStack newStackWith(int ... items) {
        return new IntArrayStack(items);
    }

    public static IntArrayStack newStack(IntIterable items) {
        IntArrayStack stack = new IntArrayStack(items.size());
        stack.delegate = IntArrayList.newList(items);
        return stack;
    }

    public static IntArrayStack newStackFromTopToBottom(IntIterable items) {
        IntArrayStack stack = new IntArrayStack(items.size());
        stack.delegate = IntArrayList.newList(items).reverseThis();
        return stack;
    }

    public void push(int item) {
        this.delegate.add(item);
    }

    public int pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    private void checkEmptyStack() {
        if (this.delegate.isEmpty()) {
            throw new EmptyStackException();
        }
    }

    public IntList pop(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new IntArrayList(0);
        }
        IntArrayList subList = new IntArrayList(count);
        while (count > 0) {
            subList.add(this.pop());
            --count;
        }
        return subList;
    }

    private void checkPositiveValueForCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    private void checkSizeLessThanCount(int count) {
        if (this.delegate.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.delegate.size());
        }
    }

    public MutableIntStack select(IntPredicate predicate) {
        return IntArrayStack.newStackFromTopToBottom(this.delegate.asReversed().select(predicate));
    }

    public MutableIntStack reject(IntPredicate predicate) {
        return IntArrayStack.newStackFromTopToBottom(this.delegate.asReversed().reject(predicate));
    }

    public int peek() {
        this.checkEmptyStack();
        return this.delegate.getLast();
    }

    public IntList peek(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new IntArrayList(0);
        }
        IntArrayList subList = new IntArrayList(count);
        int index = this.delegate.size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.delegate.get(index - i));
        }
        return subList;
    }

    public int peekAt(int index) {
        this.rangeCheck(index);
        return this.delegate.get(this.delegate.size() - 1 - index);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.delegate.size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.delegate.size() - 1));
        }
    }

    public IntIterator intIterator() {
        return this.delegate.asReversed().intIterator();
    }

    public void forEach(IntProcedure procedure) {
        this.delegate.asReversed().forEach(procedure);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    public int count(IntPredicate predicate) {
        return this.delegate.asReversed().count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.delegate.asReversed().anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.delegate.asReversed().allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.delegate.asReversed().noneSatisfy(predicate);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.delegate.asReversed().detectIfNone(predicate, ifNone);
    }

    public <V> MutableStack<V> collect(IntToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect(function));
    }

    public <V> V injectInto(V injectedValue, ObjectIntToObjectFunction<? super V, ? extends V> function) {
        return this.delegate.toReversed().injectInto(injectedValue, function);
    }

    public long sum() {
        return this.delegate.sum();
    }

    public int max() {
        return this.delegate.max();
    }

    public int min() {
        return this.delegate.min();
    }

    public int minIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public int maxIfEmpty(int defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public double average() {
        return this.delegate.average();
    }

    public double median() {
        return this.delegate.median();
    }

    public int[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    public int[] toArray() {
        return this.delegate.asReversed().toArray();
    }

    public boolean contains(int value) {
        return this.delegate.asReversed().contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.delegate.asReversed().containsAll(source);
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof IntStack)) {
            return false;
        }
        IntStack stack = (IntStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        IntIterable iterable = this.delegate.asReversed();
        IntIterator iterator = iterable.intIterator();
        while (iterator.hasNext()) {
            int item = iterator.next();
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    public String toString() {
        return this.delegate.asReversed().toString();
    }

    public String makeString() {
        return this.delegate.asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.delegate.asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.delegate.asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.delegate.asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.delegate.asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.asReversed().appendString(appendable, start, separator, end);
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newList((IntIterable)this).sortThis();
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public MutableIntStack asUnmodifiable() {
        return new UnmodifiableIntStack(this);
    }

    public MutableIntStack asSynchronized() {
        return new SynchronizedIntStack(this);
    }

    public ImmutableIntStack toImmutable() {
        return IntStacks.immutable.withAll((IntIterable)this.delegate);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        IntIterator iterator = this.delegate.asReversed().intIterator();
        while (iterator.hasNext()) {
            int each = iterator.next();
            out.writeInt(each);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size = in.readInt();
        int[] array = new int[size];
        for (int i = size - 1; i >= 0; --i) {
            array[i] = in.readInt();
        }
        this.delegate = IntArrayList.newListWith(array);
    }
}

