/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.factory.bag.primitive.ImmutableBooleanBagFactory;
import com.gs.collections.api.bag.primitive.ImmutableBooleanBag;

/**
 * ImmutableBooleanBagFactoryImpl is a factory implementation which creates instances of type {@link ImmutableBooleanBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableBooleanBagFactoryImpl implements ImmutableBooleanBagFactory
{
    public ImmutableBooleanBag of()
    {
        return this.with();
    }

    public ImmutableBooleanBag with()
    {
        return ImmutableBooleanEmptyBag.INSTANCE;
    }

    public ImmutableBooleanBag of(boolean one)
    {
        return this.with(one);
    }

    public ImmutableBooleanBag with(boolean one)
    {
        return new ImmutableBooleanSingletonBag(one);
    }

    public ImmutableBooleanBag of(boolean... items)
    {
        return this.with(items);
    }

    public ImmutableBooleanBag with(boolean... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableBooleanHashBag.newBagWith(items);
    }

    public ImmutableBooleanBag ofAll(BooleanIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableBooleanBag withAll(BooleanIterable items)
    {
        if (items instanceof ImmutableBooleanBag)
        {
            return (ImmutableBooleanBag) items;
        }
        return this.with(items.toArray());
    }
}
