/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.ImmutableByteBag;
import com.gs.collections.api.bag.primitive.ByteBag;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.factory.primitive.ByteBags;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableByteSingletonBag is an optimization for {@link ImmutableByteBag} of size 1.
 * This file was automatically generated from template file immutablePrimitiveSingletonBag.stg.
 *
 * @since 4.0.
 */
@Immutable
final class ImmutableByteSingletonBag implements ImmutableByteBag, Serializable
{
    private static final long serialVersionUID = 1L;

    private final byte element1;

    ImmutableByteSingletonBag (byte element)
    {
        this.element1 = element;
    }

    public ImmutableByteBag newWith(byte element)
    {
        return ByteBags.immutable.with(this.element1, element);
    }

    public ImmutableByteBag newWithout(byte element)
    {
        return this.element1 == element ? ByteBags.immutable.with() : this;
    }

    public ImmutableByteBag newWithAll(ByteIterable elements)
    {
        return ByteHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    public ImmutableByteBag newWithoutAll(ByteIterable elements)
    {
        return elements.contains(this.element1) ? ByteBags.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public boolean contains(byte value)
    {
        return this.element1 == value;
    }

    public boolean containsAll(ByteIterable source)
    {
        for (ByteIterator iterator = source.byteIterator(); iterator.hasNext(); )
        {
            if (this.element1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(byte... source)
    {
        for (byte value : source)
        {
            if (this.element1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public void forEach(ByteProcedure procedure)
    {
        procedure.value(this.element1);
    }

    public ImmutableByteBag select(BytePredicate predicate)
    {
        return predicate.accept(this.element1) ? ByteHashBag.newBagWith(this.element1).toImmutable()
                : new ByteHashBag().toImmutable();
    }

    public ImmutableByteBag reject(BytePredicate predicate)
    {
        return predicate.accept(this.element1) ? new ByteHashBag().toImmutable()
                : ByteHashBag.newBagWith(this.element1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return HashBag.<V>newBagWith(function.valueOf(this.element1)).toImmutable();
    }

    public MutableByteList toList()
    {
        return ByteArrayList.newListWith(this.element1);
    }

    public int sizeDistinct()
    {
        return 1;
    }

    public int occurrencesOf(byte item)
    {
        return this.element1 == item ? 1 : 0;
    }

    public void forEachWithOccurrences(ByteIntProcedure byteIntProcedure)
    {
        byteIntProcedure.value(this.element1, 1);
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public int count(BytePredicate predicate)
    {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public long sum()
    {
        return this.element1;
    }

    public byte min()
    {
        return this.element1;
    }

    public byte max()
    {
        return this.element1;
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return this.element1;
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return this.element1;
    }

    public double average()
    {
        return this.element1;
    }

    public double median()
    {
        return this.element1;
    }

    public byte[] toSortedArray()
    {
        return new byte[]{this.element1};
    }

    public MutableByteList toSortedList()
    {
        return ByteArrayList.newListWith(this.element1);
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return !predicate.accept(this.element1);
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ByteBag))
        {
            return false;
        }
        ByteBag bag = (ByteBag) obj;
        if (bag.size() != 1)
        {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    @Override
    public int hashCode()
    {
        return (int) this.element1 ^ 1;
    }

    public MutableByteSet toSet()
    {
        return ByteHashSet.newSetWith(this.element1);
    }

    public MutableByteBag toBag()
    {
        return ByteHashBag.newBagWith(this.element1);
    }

    public ImmutableByteBag toImmutable()
    {
        return this;
    }

    public LazyByteIterable asLazy()
    {
        return new LazyByteIterableAdapter(this);
    }

    public byte[] toArray()
    {
        return new byte[]{this.element1};
    }

    @Override
    public String toString()
    {
        return '[' + this.makeString() + ']';
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public ByteIterator byteIterator()
    {
        return ByteHashBag.newBagWith(this.element1).byteIterator();
    }
}

