/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.factory.bag.primitive.ImmutableCharBagFactory;
import com.gs.collections.api.bag.primitive.ImmutableCharBag;

/**
 * ImmutableCharBagFactoryImpl is a factory implementation which creates instances of type {@link ImmutableCharBag}.
 * This file was automatically generated from template file immutablePrimitiveBagFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableCharBagFactoryImpl implements ImmutableCharBagFactory
{
    public ImmutableCharBag of()
    {
        return this.with();
    }

    public ImmutableCharBag with()
    {
        return ImmutableCharEmptyBag.INSTANCE;
    }

    public ImmutableCharBag of(char one)
    {
        return this.with(one);
    }

    public ImmutableCharBag with(char one)
    {
        return new ImmutableCharSingletonBag(one);
    }

    public ImmutableCharBag of(char... items)
    {
        return this.with(items);
    }

    public ImmutableCharBag with(char... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableCharHashBag.newBagWith(items);
    }

    public ImmutableCharBag ofAll(CharIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableCharBag withAll(CharIterable items)
    {
        if (items instanceof ImmutableCharBag)
        {
            return (ImmutableCharBag) items;
        }
        return this.with(items.toArray());
    }
}
