/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.ImmutableIntBag;
import com.gs.collections.api.bag.primitive.IntBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.primitive.IntIntProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.factory.primitive.IntBags;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableIntSingletonBag is an optimization for {@link ImmutableIntBag} of size 1.
 * This file was automatically generated from template file immutablePrimitiveSingletonBag.stg.
 *
 * @since 4.0.
 */
@Immutable
final class ImmutableIntSingletonBag implements ImmutableIntBag, Serializable
{
    private static final long serialVersionUID = 1L;

    private final int element1;

    ImmutableIntSingletonBag (int element)
    {
        this.element1 = element;
    }

    public ImmutableIntBag newWith(int element)
    {
        return IntBags.immutable.with(this.element1, element);
    }

    public ImmutableIntBag newWithout(int element)
    {
        return this.element1 == element ? IntBags.immutable.with() : this;
    }

    public ImmutableIntBag newWithAll(IntIterable elements)
    {
        return IntHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    public ImmutableIntBag newWithoutAll(IntIterable elements)
    {
        return elements.contains(this.element1) ? IntBags.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public boolean contains(int value)
    {
        return this.element1 == value;
    }

    public boolean containsAll(IntIterable source)
    {
        for (IntIterator iterator = source.intIterator(); iterator.hasNext(); )
        {
            if (this.element1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(int... source)
    {
        for (int value : source)
        {
            if (this.element1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public void forEach(IntProcedure procedure)
    {
        procedure.value(this.element1);
    }

    public ImmutableIntBag select(IntPredicate predicate)
    {
        return predicate.accept(this.element1) ? IntHashBag.newBagWith(this.element1).toImmutable()
                : new IntHashBag().toImmutable();
    }

    public ImmutableIntBag reject(IntPredicate predicate)
    {
        return predicate.accept(this.element1) ? new IntHashBag().toImmutable()
                : IntHashBag.newBagWith(this.element1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function)
    {
        return HashBag.<V>newBagWith(function.valueOf(this.element1)).toImmutable();
    }

    public MutableIntList toList()
    {
        return IntArrayList.newListWith(this.element1);
    }

    public int sizeDistinct()
    {
        return 1;
    }

    public int occurrencesOf(int item)
    {
        return this.element1 == item ? 1 : 0;
    }

    public void forEachWithOccurrences(IntIntProcedure intIntProcedure)
    {
        intIntProcedure.value(this.element1, 1);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone)
    {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public int count(IntPredicate predicate)
    {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(IntPredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public long sum()
    {
        return this.element1;
    }

    public int min()
    {
        return this.element1;
    }

    public int max()
    {
        return this.element1;
    }

    public int maxIfEmpty(int defaultValue)
    {
        return this.element1;
    }

    public int minIfEmpty(int defaultValue)
    {
        return this.element1;
    }

    public double average()
    {
        return this.element1;
    }

    public double median()
    {
        return this.element1;
    }

    public int[] toSortedArray()
    {
        return new int[]{this.element1};
    }

    public MutableIntList toSortedList()
    {
        return IntArrayList.newListWith(this.element1);
    }

    public boolean noneSatisfy(IntPredicate predicate)
    {
        return !predicate.accept(this.element1);
    }

    public boolean allSatisfy(IntPredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof IntBag))
        {
            return false;
        }
        IntBag bag = (IntBag) obj;
        if (bag.size() != 1)
        {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    @Override
    public int hashCode()
    {
        return this.element1 ^ 1;
    }

    public MutableIntSet toSet()
    {
        return IntHashSet.newSetWith(this.element1);
    }

    public MutableIntBag toBag()
    {
        return IntHashBag.newBagWith(this.element1);
    }

    public ImmutableIntBag toImmutable()
    {
        return this;
    }

    public LazyIntIterable asLazy()
    {
        return new LazyIntIterableAdapter(this);
    }

    public int[] toArray()
    {
        return new int[]{this.element1};
    }

    @Override
    public String toString()
    {
        return '[' + this.makeString() + ']';
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public IntIterator intIterator()
    {
        return IntHashBag.newBagWith(this.element1).intIterator();
    }
}

