/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.ImmutableShortBag;
import com.gs.collections.api.bag.primitive.ShortBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortIntProcedure;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.bag.mutable.primitive.ShortHashBag;
import com.gs.collections.impl.factory.primitive.ShortBags;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ShortArrayList;
import com.gs.collections.impl.set.mutable.primitive.ShortHashSet;
import net.jcip.annotations.Immutable;

/**
 * ImmutableShortSingletonBag is an optimization for {@link ImmutableShortBag} of size 1.
 * This file was automatically generated from template file immutablePrimitiveSingletonBag.stg.
 *
 * @since 4.0.
 */
@Immutable
final class ImmutableShortSingletonBag implements ImmutableShortBag, Serializable
{
    private static final long serialVersionUID = 1L;

    private final short element1;

    ImmutableShortSingletonBag (short element)
    {
        this.element1 = element;
    }

    public ImmutableShortBag newWith(short element)
    {
        return ShortBags.immutable.with(this.element1, element);
    }

    public ImmutableShortBag newWithout(short element)
    {
        return this.element1 == element ? ShortBags.immutable.with() : this;
    }

    public ImmutableShortBag newWithAll(ShortIterable elements)
    {
        return ShortHashBag.newBag(elements).with(this.element1).toImmutable();
    }

    public ImmutableShortBag newWithoutAll(ShortIterable elements)
    {
        return elements.contains(this.element1) ? ShortBags.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public boolean contains(short value)
    {
        return this.element1 == value;
    }

    public boolean containsAll(ShortIterable source)
    {
        for (ShortIterator iterator = source.shortIterator(); iterator.hasNext(); )
        {
            if (this.element1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(short... source)
    {
        for (short value : source)
        {
            if (this.element1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public void forEach(ShortProcedure procedure)
    {
        procedure.value(this.element1);
    }

    public ImmutableShortBag select(ShortPredicate predicate)
    {
        return predicate.accept(this.element1) ? ShortHashBag.newBagWith(this.element1).toImmutable()
                : new ShortHashBag().toImmutable();
    }

    public ImmutableShortBag reject(ShortPredicate predicate)
    {
        return predicate.accept(this.element1) ? new ShortHashBag().toImmutable()
                : ShortHashBag.newBagWith(this.element1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return HashBag.<V>newBagWith(function.valueOf(this.element1)).toImmutable();
    }

    public MutableShortList toList()
    {
        return ShortArrayList.newListWith(this.element1);
    }

    public int sizeDistinct()
    {
        return 1;
    }

    public int occurrencesOf(short item)
    {
        return this.element1 == item ? 1 : 0;
    }

    public void forEachWithOccurrences(ShortIntProcedure shortIntProcedure)
    {
        shortIntProcedure.value(this.element1, 1);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return predicate.accept(this.element1) ? this.element1 : ifNone;
    }

    public int count(ShortPredicate predicate)
    {
        return predicate.accept(this.element1) ? 1 : 0;
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public long sum()
    {
        return this.element1;
    }

    public short min()
    {
        return this.element1;
    }

    public short max()
    {
        return this.element1;
    }

    public short maxIfEmpty(short defaultValue)
    {
        return this.element1;
    }

    public short minIfEmpty(short defaultValue)
    {
        return this.element1;
    }

    public double average()
    {
        return this.element1;
    }

    public double median()
    {
        return this.element1;
    }

    public short[] toSortedArray()
    {
        return new short[]{this.element1};
    }

    public MutableShortList toSortedList()
    {
        return ShortArrayList.newListWith(this.element1);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return !predicate.accept(this.element1);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return predicate.accept(this.element1);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.element1);
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof ShortBag))
        {
            return false;
        }
        ShortBag bag = (ShortBag) obj;
        if (bag.size() != 1)
        {
            return false;
        }
        return this.occurrencesOf(this.element1) == bag.occurrencesOf(this.element1);
    }

    @Override
    public int hashCode()
    {
        return (int) this.element1 ^ 1;
    }

    public MutableShortSet toSet()
    {
        return ShortHashSet.newSetWith(this.element1);
    }

    public MutableShortBag toBag()
    {
        return ShortHashBag.newBagWith(this.element1);
    }

    public ImmutableShortBag toImmutable()
    {
        return this;
    }

    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    public short[] toArray()
    {
        return new short[]{this.element1};
    }

    @Override
    public String toString()
    {
        return '[' + this.makeString() + ']';
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.element1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }

    public ShortIterator shortIterator()
    {
        return ShortHashBag.newBagWith(this.element1).shortIterator();
    }
}

