/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.bag.mutable.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.bag.primitive.ImmutableShortBag;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortIntProcedure;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableShortCollection;
import com.gs.collections.impl.factory.primitive.ShortBags;
import com.gs.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveBag.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableShortBag
        extends AbstractUnmodifiableShortCollection
        implements MutableShortBag
{
    private static final long serialVersionUID = 1L;

    UnmodifiableShortBag(MutableShortBag bag)
    {
        super(bag);
    }

    private MutableShortBag getMutableShortBag()
    {
        return (MutableShortBag) this.getShortCollection();
    }

    @Override
    public UnmodifiableShortBag with(short element)
    {
        throw new UnsupportedOperationException("Cannot use with on an UnmodifiableShortBag");
    }

    @Override
    public UnmodifiableShortBag without(short element)
    {
        throw new UnsupportedOperationException("Cannot use without on an UnmodifiableShortBag");
    }

    @Override
    public UnmodifiableShortBag withAll(ShortIterable elements)
    {
        throw new UnsupportedOperationException("Cannot use withAll on an UnmodifiableShortBag");
    }

    @Override
    public UnmodifiableShortBag withoutAll(ShortIterable elements)
    {
        throw new UnsupportedOperationException("Cannot use withoutAll on an UnmodifiableShortBag");
    }

    public void addOccurrences(short item, int occurrences)
    {
        throw new UnsupportedOperationException("Cannot use addOccurrences on an UnmodifiableShortBag");
    }

    public boolean removeOccurrences(short item, int occurrences)
    {
        throw new UnsupportedOperationException("Cannot use removeOccurrences on an UnmodifiableShortBag");
    }

    public int sizeDistinct()
    {
        return this.getMutableShortBag().sizeDistinct();
    }

    public int occurrencesOf(short item)
    {
        return this.getMutableShortBag().occurrencesOf(item);
    }

    public void forEachWithOccurrences(ShortIntProcedure procedure)
    {
        this.getMutableShortBag().forEachWithOccurrences(procedure);
    }

    @Override
    public MutableShortBag select(ShortPredicate predicate)
    {
        return this.getMutableShortBag().select(predicate);
    }

    @Override
    public MutableShortBag reject(ShortPredicate predicate)
    {
        return this.getMutableShortBag().reject(predicate);
    }

    @Override
    public <V> MutableBag<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return this.getMutableShortBag().collect(function);
    }

    @Override
    public boolean equals(Object otherBag)
    {
        return this.getMutableShortBag().equals(otherBag);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableShortBag().hashCode();
    }

    @Override
    public LazyShortIterable asLazy()
    {
        return new LazyShortIterableAdapter(this);
    }

    @Override
    public MutableShortBag asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableShortBag asSynchronized()
    {
        return new SynchronizedShortBag(this);
    }

    @Override
    public ImmutableShortBag toImmutable()
    {
        return ShortBags.immutable.withAll(this);
    }
}
