/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.block.comparator.primitive;

import com.gs.collections.api.block.SerializableComparator;
import com.gs.collections.api.block.function.primitive.CharFunction;

/**
 * A Comparator which takes a CharFunction to compare a iterator char value retrieved from an object.
 */
public class CharFunctionComparator<T>
        implements SerializableComparator<T>
{
    private static final long serialVersionUID = 1L;

    private final CharFunction<T> function;

    public CharFunctionComparator( CharFunction<T> function)
    {
        this.function = function;
    }

    public int compare(T o1, T o2)
    {
        char one = this.function.charValueOf(o1);
        char two = this.function.charValueOf(o2);
        return one - two;
    }
}
