/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.factory.primitive;

import com.gs.collections.api.factory.stack.primitive.ImmutableFloatStackFactory;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableFloatStackFactoryImpl;

/**
 * FloatStacks is a static utility for creating {@link ImmutableFloatStackFactory}.
 * This file was automatically generated from template file primitiveStacks.stg.
 *
 * @since 4.0.
 */
@SuppressWarnings("ConstantNamingConvention")
public final class FloatStacks
{
    public static final ImmutableFloatStackFactory immutable = new ImmutableFloatStackFactoryImpl();

    private FloatStacks()
    {
        throw new AssertionError("Suppress default constructor for noninstantiability");
    }
}
