/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.block.factory.primitive.DoublePredicates;

/**
 * This file was automatically generated from template file lazyPrimitiveIterableAdapter.stg.
 *
 * @since 3.0
 */
public class LazyDoubleIterableAdapter
        implements LazyDoubleIterable
{
    private final DoubleIterable delegate;

    public LazyDoubleIterableAdapter(DoubleIterable delegate)
    {
        this.delegate = delegate;
    }

    public DoubleIterator doubleIterator()
    {
        return this.delegate.doubleIterator();
    }

    public void forEach(DoubleProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public int count(DoublePredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public LazyDoubleIterable select(DoublePredicate predicate)
    {
        return new SelectDoubleIterable(this.delegate, predicate);
    }

    public LazyDoubleIterable reject(DoublePredicate predicate)
    {
        return new SelectDoubleIterable(this.delegate, DoublePredicates.not(predicate));
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> LazyIterable<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return new CollectDoubleToObjectIterable<V>(this.delegate, function);
    }

    public double sum()
    {
        return this.delegate.sum();
    }

    public double max()
    {
        return this.delegate.max();
    }

    public double min()
    {
        return this.delegate.min();
    }

    public double minIfEmpty(double defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double maxIfEmpty(double defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public double[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableDoubleList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public double[] toArray()
    {
        return this.delegate.toArray();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public boolean contains(double value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(double... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableDoubleList toList()
    {
        return this.delegate.toList();
    }

    public MutableDoubleSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableDoubleBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyDoubleIterable asLazy()
    {
        return this;
    }
}
