/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.LongIterable;
import com.gs.collections.api.LazyLongIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableLongBag;
import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.list.primitive.MutableLongList;
import com.gs.collections.api.set.primitive.MutableLongSet;
import com.gs.collections.impl.block.factory.primitive.LongPredicates;

/**
 * This file was automatically generated from template file lazyPrimitiveIterableAdapter.stg.
 *
 * @since 3.0
 */
public class LazyLongIterableAdapter
        implements LazyLongIterable
{
    private final LongIterable delegate;

    public LazyLongIterableAdapter(LongIterable delegate)
    {
        this.delegate = delegate;
    }

    public LongIterator longIterator()
    {
        return this.delegate.longIterator();
    }

    public void forEach(LongProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public int count(LongPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(LongPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(LongPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(LongPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public LazyLongIterable select(LongPredicate predicate)
    {
        return new SelectLongIterable(this.delegate, predicate);
    }

    public LazyLongIterable reject(LongPredicate predicate)
    {
        return new SelectLongIterable(this.delegate, LongPredicates.not(predicate));
    }

    public long detectIfNone(LongPredicate predicate, long ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> LazyIterable<V> collect(LongToObjectFunction<? extends V> function)
    {
        return new CollectLongToObjectIterable<V>(this.delegate, function);
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public long max()
    {
        return this.delegate.max();
    }

    public long min()
    {
        return this.delegate.min();
    }

    public long minIfEmpty(long defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public long maxIfEmpty(long defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public long[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableLongList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public long[] toArray()
    {
        return this.delegate.toArray();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public boolean contains(long value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(long... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(LongIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableLongList toList()
    {
        return this.delegate.toList();
    }

    public MutableLongSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableLongBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyLongIterable asLazy()
    {
        return this;
    }
}
