/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.lazy.primitive;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.iterator.ShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.impl.block.factory.primitive.ShortPredicates;

/**
 * This file was automatically generated from template file lazyPrimitiveIterableAdapter.stg.
 *
 * @since 3.0
 */
public class LazyShortIterableAdapter
        implements LazyShortIterable
{
    private final ShortIterable delegate;

    public LazyShortIterableAdapter(ShortIterable delegate)
    {
        this.delegate = delegate;
    }

    public ShortIterator shortIterator()
    {
        return this.delegate.shortIterator();
    }

    public void forEach(ShortProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public int count(ShortPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public LazyShortIterable select(ShortPredicate predicate)
    {
        return new SelectShortIterable(this.delegate, predicate);
    }

    public LazyShortIterable reject(ShortPredicate predicate)
    {
        return new SelectShortIterable(this.delegate, ShortPredicates.not(predicate));
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> LazyIterable<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return new CollectShortToObjectIterable<V>(this.delegate, function);
    }

    public long sum()
    {
        return this.delegate.sum();
    }

    public short max()
    {
        return this.delegate.max();
    }

    public short min()
    {
        return this.delegate.min();
    }

    public short minIfEmpty(short defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public short maxIfEmpty(short defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public short[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }

    public MutableShortList toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public short[] toArray()
    {
        return this.delegate.toArray();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public boolean contains(short value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(short... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(ShortIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableShortList toList()
    {
        return this.delegate.toList();
    }

    public MutableShortSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableShortBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyShortIterable asLazy()
    {
        return this;
    }
}
