/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableByteListFactory;
import com.gs.collections.api.list.primitive.ImmutableByteList;

/**
 * ImmutableByteListFactoryImpl is a factory implementation which creates instances of type {@link ImmutableByteList}.
 * This file was automatically generated from template file immutablePrimitiveListFactoryImpl.stg.
 *
 * @since 3.2.
 */
public class ImmutableByteListFactoryImpl implements ImmutableByteListFactory
{
    public ImmutableByteList of()
    {
        return this.with();
    }

    public ImmutableByteList with()
    {
        return ImmutableByteEmptyList.INSTANCE;
    }

    public ImmutableByteList of(byte one)
    {
        return this.with(one);
    }

    public ImmutableByteList with(byte one)
    {
        return new ImmutableByteSingletonList(one);
    }

    public ImmutableByteList of(byte... items)
    {
        return this.with(items);
    }

    public ImmutableByteList with(byte... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableByteArrayList.newListWith(items);
    }

    public ImmutableByteList ofAll(ByteIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableByteList withAll(ByteIterable items)
    {
        if (items instanceof ImmutableByteList)
        {
            return (ImmutableByteList) items;
        }
        return this.with(items.toArray());
    }
}
