/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.immutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.factory.list.primitive.ImmutableFloatListFactory;
import com.gs.collections.api.list.primitive.ImmutableFloatList;

/**
 * ImmutableFloatListFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatList}.
 * This file was automatically generated from template file immutablePrimitiveListFactoryImpl.stg.
 *
 * @since 3.2.
 */
public class ImmutableFloatListFactoryImpl implements ImmutableFloatListFactory
{
    public ImmutableFloatList of()
    {
        return this.with();
    }

    public ImmutableFloatList with()
    {
        return ImmutableFloatEmptyList.INSTANCE;
    }

    public ImmutableFloatList of(float one)
    {
        return this.with(one);
    }

    public ImmutableFloatList with(float one)
    {
        return new ImmutableFloatSingletonList(one);
    }

    public ImmutableFloatList of(float... items)
    {
        return this.with(items);
    }

    public ImmutableFloatList with(float... items)
    {
        if (items == null || items.length == 0)
        {
            return this.with();
        }
        if (items.length == 1)
        {
            return this.with(items[0]);
        }
        return ImmutableFloatArrayList.newListWith(items);
    }

    public ImmutableFloatList ofAll(FloatIterable items)
    {
        return this.withAll(items);
    }

    public ImmutableFloatList withAll(FloatIterable items)
    {
        if (items instanceof ImmutableFloatList)
        {
            return (ImmutableFloatList) items;
        }
        return this.with(items.toArray());
    }
}
