/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.list.mutable.primitive;

import java.util.Collection;
import java.util.Collections;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.list.primitive.CharList;
import com.gs.collections.api.list.primitive.ImmutableCharList;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.impl.collection.mutable.primitive.AbstractSynchronizedCharCollection;
import com.gs.collections.impl.factory.primitive.CharLists;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/**
 * A synchronized view of a {@link MutableCharList}. It is imperative that the user manually synchronize on the collection when iterating over it using the
 * {@link CharIterator}, as per {@link Collections#synchronizedCollection(Collection)}.
 * <p>
 * This file was automatically generated from template file synchronizedPrimitiveList.stg.
 * </p>
 *
 * @see MutableCharList#asSynchronized()
 * @see MutableList#asSynchronized()
 * @since 3.1.
 */
@ThreadSafe
public final class SynchronizedCharList
        extends AbstractSynchronizedCharCollection
        implements MutableCharList
{
    private static final long serialVersionUID = 1L;

    SynchronizedCharList(MutableCharList list)
    {
        super(list);
    }

    SynchronizedCharList(MutableCharList list, Object newLock)
    {
        super(list, newLock);
    }

    @GuardedBy("getLock()")
    private MutableCharList getMutableCharList()
    {
        return (MutableCharList) this.getCharCollection();
    }

    public char get(int index)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().get(index);
        }
    }

    public char getFirst()
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().getFirst();
        }
    }

    public char getLast()
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().getLast();
        }
    }

    public int indexOf(char value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().indexOf(value);
        }
    }

    public int lastIndexOf(char value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().lastIndexOf(value);
        }
    }

    public void addAtIndex(int index, char element)
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().addAtIndex(index, element);
        }
    }

    public boolean addAllAtIndex(int index, char... source)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().addAllAtIndex(index, source);
        }
    }

    public boolean addAllAtIndex(int index, CharIterable source)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().addAllAtIndex(index, source);
        }
    }

    public char removeAtIndex(int index)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().removeAtIndex(index);
        }
    }

    public char set(int index, char element)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().set(index, element);
        }
    }

    @Override
    public SynchronizedCharList with(char element)
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().add(element);
        }
        return this;
    }

    @Override
    public SynchronizedCharList without(char element)
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().remove(element);
        }
        return this;
    }

    @Override
    public SynchronizedCharList withAll(CharIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().addAll(elements.toArray());
        }
        return this;
    }

    @Override
    public SynchronizedCharList withoutAll(CharIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().removeAll(elements);
        }
        return this;
    }

    @Override
    public MutableCharList select(CharPredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().select(predicate);
        }
    }

    @Override
    public MutableCharList reject(CharPredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().reject(predicate);
        }
    }

    @Override
    public <V> MutableList<V> collect(CharToObjectFunction<? extends V> function)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().collect(function);
        }
    }

    public MutableCharList sortThis()
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().sortThis();
        }
        return this;
    }

    public long dotProduct(CharList list)
    {
        return this.getMutableCharList().dotProduct(list);
    }

    @Override
    public boolean equals(Object otherList)
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().equals(otherList);
        }
    }

    @Override
    public int hashCode()
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().hashCode();
        }
    }

    @Override
    public LazyCharIterable asLazy()
    {
        synchronized (this.getLock())
        {
            return new LazyCharIterableAdapter(this);
        }
    }

    @Override
    public MutableCharList asUnmodifiable()
    {
        return new UnmodifiableCharList(this);
    }

    @Override
    public MutableCharList asSynchronized()
    {
        return this;
    }

    @Override
    public ImmutableCharList toImmutable()
    {
        int size = this.size();
        if (size == 0)
        {
            return CharLists.immutable.with();
        }
        if (size == 1)
        {
            return CharLists.immutable.with(this.getFirst());
        }
        return CharLists.immutable.with(this.toArray());
    }

    public MutableCharList reverseThis()
    {
        synchronized (this.getLock())
        {
            this.getMutableCharList().reverseThis();
        }
        return this;
    }

    public MutableCharList toReversed()
    {
        synchronized (this.getLock())
        {
            return this.getMutableCharList().toReversed();
        }
    }
}
