/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableCharFloatMapFactory;
import com.gs.collections.api.map.primitive.ImmutableCharFloatMap;
import com.gs.collections.api.map.primitive.CharFloatMap;

/**
 * ImmutableCharFloatMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableCharFloatMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableCharFloatMapFactoryImpl implements ImmutableCharFloatMapFactory
{
    public ImmutableCharFloatMap of()
    {
        return this.with();
    }

    public ImmutableCharFloatMap with()
    {
        return ImmutableCharFloatEmptyMap.INSTANCE;
    }

    public ImmutableCharFloatMap of(char key, float value)
    {
        return this.with(key, value);
    }

    public ImmutableCharFloatMap with(char key, float value)
    {
        return new ImmutableCharFloatSingletonMap(key, value);
    }

    public ImmutableCharFloatMap ofAll(CharFloatMap map)
    {
        return this.withAll(map);
    }

    public ImmutableCharFloatMap withAll(CharFloatMap map)
    {
        if (map instanceof ImmutableCharFloatMap)
        {
            return (ImmutableCharFloatMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            char key = map.keysView().charIterator().next();
            return new ImmutableCharFloatSingletonMap(key, map.get(key));
        }
        return new ImmutableCharFloatHashMap(map);
    }
}
