/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.factory.map.primitive.ImmutableCharObjectMapFactory;
import com.gs.collections.api.map.primitive.ImmutableCharObjectMap;
import com.gs.collections.api.map.primitive.CharObjectMap;

/**
 * ImmutableCharObjectMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableCharObjectMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableCharObjectMapFactoryImpl implements ImmutableCharObjectMapFactory
{
    public <V> ImmutableCharObjectMap<V> of()
    {
        return this.with();
    }

    public <V> ImmutableCharObjectMap<V> with()
    {
        return (ImmutableCharObjectMap<V>) ImmutableCharObjectEmptyMap.INSTANCE;
    }

    public <V> ImmutableCharObjectMap<V> of(char key, V value)
    {
        return this.with(key, value);
    }

    public <V> ImmutableCharObjectMap<V> with(char key, V value)
    {
        return new ImmutableCharObjectSingletonMap<V>(key, value);
    }

    public <V> ImmutableCharObjectMap<V> ofAll(CharObjectMap<? extends V> map)
    {
        return this.withAll(map);
    }

    public <V> ImmutableCharObjectMap<V> withAll(CharObjectMap<? extends V> map)
    {
        if (map instanceof ImmutableCharObjectMap)
        {
            return (ImmutableCharObjectMap<V>) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            //TODO use keysView() when available.
            final char[] array = new char[1];
            map.forEachKey(new CharProcedure()
            {
                public void value(char each)
                {
                    array[0] = each;
                }
            });
            return new ImmutableCharObjectSingletonMap<V>(array[0], map.get(array[0]));
        }
        return new ImmutableCharObjectHashMap<V>(map);
    }
}
