/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.DoubleDoublePredicate;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.DoubleDoubleProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.DoubleDoubleMap;
import com.gs.collections.api.map.primitive.ImmutableDoubleDoubleMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.bag.mutable.primitive.DoubleHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.DoubleArrayList;
import com.gs.collections.impl.map.mutable.primitive.DoubleDoubleHashMap;
import com.gs.collections.impl.set.mutable.primitive.DoubleHashSet;

/**
 * ImmutableDoubleDoubleEmptyMap is an optimization for {@link ImmutableDoubleDoubleMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableDoubleDoubleEmptyMap implements ImmutableDoubleDoubleMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_VALUE = 0.0;
    static final ImmutableDoubleDoubleMap INSTANCE = new ImmutableDoubleDoubleEmptyMap();

    private Object readResolve()
    {
        return INSTANCE;
    }

    public double get(double key)
    {
        return EMPTY_VALUE;
    }

    public double getIfAbsent(double key, double ifAbsent)
    {
        return ifAbsent;
    }

    public double getOrThrow(double key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(double key)
    {
        return false;
    }

    public boolean containsValue(double value)
    {
        return false;
    }

    public void forEachValue(DoubleProcedure procedure)
    {
    }

    public void forEachKey(DoubleProcedure procedure)
    {
    }

    public void forEachKeyValue(DoubleDoubleProcedure procedure)
    {
    }

    public LazyDoubleIterable keysView()
    {
        return new DoubleDoubleHashMap(0).keysView();
    }

    public ImmutableDoubleDoubleMap select(DoubleDoublePredicate predicate)
    {
        return this;
    }

    public ImmutableDoubleDoubleMap reject(DoubleDoublePredicate predicate)
    {
        return this;
    }

    public ImmutableDoubleDoubleMap toImmutable()
    {
        return this;
    }

    public DoubleIterator doubleIterator()
    {
        return new InternalDoubleIterator();
    }

    private static class InternalDoubleIterator implements DoubleIterator
    {
        public boolean hasNext()
        {
            return false;
        }

        public double next()
        {
            throw new NoSuchElementException();
        }
    }

    public void forEach(DoubleProcedure procedure)
    {
    }

    public int count(DoublePredicate predicate)
    {
        return 0;
    }

    public double sum()
    {
        return 0.0;
    }

    public double min()
    {
        throw new NoSuchElementException();
    }

    public double max()
    {
        throw new NoSuchElementException();
    }

    public double maxIfEmpty(double defaultValue)
    {
        return defaultValue;
    }

    public double minIfEmpty(double defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public double[] toSortedArray()
    {
        return new double[0];
    }

    public MutableDoubleList toSortedList()
    {
        return new DoubleArrayList();
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return true;
    }

    public ImmutableDoubleCollection select(DoublePredicate predicate)
    {
        return DoubleLists.immutable.with();
    }

    public ImmutableDoubleCollection reject(DoublePredicate predicate)
    {
        return DoubleLists.immutable.with();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public double[] toArray()
    {
        return new double[0];
    }

    public boolean contains(double value)
    {
        return false;
    }

    public boolean containsAll(double... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(DoubleIterable source)
    {
        return source.isEmpty();
    }

    public MutableDoubleList toList()
    {
        return new DoubleArrayList();
    }

    public MutableDoubleSet toSet()
    {
        return new DoubleHashSet();
    }

    public MutableDoubleBag toBag()
    {
        return new DoubleHashBag();
    }

    public LazyDoubleIterable asLazy()
    {
        return new LazyDoubleIterableAdapter(this);
    }

    public ImmutableDoubleDoubleMap newWithKeyValue(double key, double value)
    {
        return new ImmutableDoubleDoubleSingletonMap(key, value);
    }

    public ImmutableDoubleDoubleMap newWithoutKey(double key)
    {
        return this;
    }

    public ImmutableDoubleDoubleMap newWithoutAllKeys(DoubleIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableDoubleSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableDoubleCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof DoubleDoubleMap))
        {
            return false;
        }
        DoubleDoubleMap map = (DoubleDoubleMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
