/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableDoubleFloatMapFactory;
import com.gs.collections.api.map.primitive.ImmutableDoubleFloatMap;
import com.gs.collections.api.map.primitive.DoubleFloatMap;

/**
 * ImmutableDoubleFloatMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableDoubleFloatMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableDoubleFloatMapFactoryImpl implements ImmutableDoubleFloatMapFactory
{
    public ImmutableDoubleFloatMap of()
    {
        return this.with();
    }

    public ImmutableDoubleFloatMap with()
    {
        return ImmutableDoubleFloatEmptyMap.INSTANCE;
    }

    public ImmutableDoubleFloatMap of(double key, float value)
    {
        return this.with(key, value);
    }

    public ImmutableDoubleFloatMap with(double key, float value)
    {
        return new ImmutableDoubleFloatSingletonMap(key, value);
    }

    public ImmutableDoubleFloatMap ofAll(DoubleFloatMap map)
    {
        return this.withAll(map);
    }

    public ImmutableDoubleFloatMap withAll(DoubleFloatMap map)
    {
        if (map instanceof ImmutableDoubleFloatMap)
        {
            return (ImmutableDoubleFloatMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            double key = map.keysView().doubleIterator().next();
            return new ImmutableDoubleFloatSingletonMap(key, map.get(key));
        }
        return new ImmutableDoubleFloatHashMap(map);
    }
}
