/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableDoubleIntMapFactory;
import com.gs.collections.api.map.primitive.ImmutableDoubleIntMap;
import com.gs.collections.api.map.primitive.DoubleIntMap;

/**
 * ImmutableDoubleIntMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableDoubleIntMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableDoubleIntMapFactoryImpl implements ImmutableDoubleIntMapFactory
{
    public ImmutableDoubleIntMap of()
    {
        return this.with();
    }

    public ImmutableDoubleIntMap with()
    {
        return ImmutableDoubleIntEmptyMap.INSTANCE;
    }

    public ImmutableDoubleIntMap of(double key, int value)
    {
        return this.with(key, value);
    }

    public ImmutableDoubleIntMap with(double key, int value)
    {
        return new ImmutableDoubleIntSingletonMap(key, value);
    }

    public ImmutableDoubleIntMap ofAll(DoubleIntMap map)
    {
        return this.withAll(map);
    }

    public ImmutableDoubleIntMap withAll(DoubleIntMap map)
    {
        if (map instanceof ImmutableDoubleIntMap)
        {
            return (ImmutableDoubleIntMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            double key = map.keysView().doubleIterator().next();
            return new ImmutableDoubleIntSingletonMap(key, map.get(key));
        }
        return new ImmutableDoubleIntHashMap(map);
    }
}
