/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatBooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.FloatBooleanMap;
import com.gs.collections.api.map.primitive.ImmutableFloatBooleanMap;
import com.gs.collections.api.map.primitive.MutableFloatBooleanMap;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.block.procedure.checked.primitive.CheckedFloatBooleanProcedure;
import com.gs.collections.impl.map.mutable.primitive.FloatBooleanHashMap;

/**
 * ImmutableFloatBooleanHashMap is the non-modifiable equivalent of {@link FloatBooleanHashMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveHashMap.stg.
 * @since 4.0.
 */
final class ImmutableFloatBooleanHashMap implements ImmutableFloatBooleanMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableFloatBooleanMap delegate;

    ImmutableFloatBooleanHashMap(FloatBooleanMap delegate)
    {
        this.delegate = new FloatBooleanHashMap(delegate);
    }

    public boolean get(float key)
    {
        return this.delegate.get(key);
    }

    public boolean getIfAbsent(float key, boolean ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean getOrThrow(float key)
    {
        return this.delegate.getOrThrow(key);
    }

    public boolean containsKey(float key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(boolean value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(BooleanProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatBooleanProcedure procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView()
    {
        return this.delegate.keysView();
    }

    public ImmutableFloatBooleanMap select(FloatBooleanPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatBooleanMap reject(FloatBooleanPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function)
    {
        return ((FloatBooleanHashMap) this.delegate).injectInto(injectedValue, function);
    }

    public ImmutableFloatBooleanMap toImmutable()
    {
        return this;
    }

    public BooleanIterator booleanIterator()
    {
        return this.delegate.booleanIterator();
    }

    public void forEach(BooleanProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(BooleanPredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableBooleanCollection select(BooleanPredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableBooleanCollection reject(BooleanPredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public boolean[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(boolean value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(boolean... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableBooleanList toList()
    {
        return this.delegate.toList();
    }

    public MutableBooleanSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableBooleanBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyBooleanIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableFloatBooleanMap newWithKeyValue(float key, boolean value)
    {
        MutableFloatBooleanMap map = new FloatBooleanHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableFloatBooleanMap newWithoutKey(float key)
    {
        MutableFloatBooleanMap map = new FloatBooleanHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableFloatBooleanMap newWithoutAllKeys(FloatIterable keys)
    {
        MutableFloatBooleanMap map = new FloatBooleanHashMap(this.size());
        map.putAll(this);
        FloatIterator iterator = keys.floatIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public MutableFloatSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableBooleanCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableFloatBooleanMapSerializationProxy(this);
    }

    protected static class ImmutableFloatBooleanMapSerializationProxy implements Externalizable
    {
        private static final long serialVersionUID = 1L;

        private FloatBooleanMap map;

        @SuppressWarnings("UnusedDeclaration")
        public ImmutableFloatBooleanMapSerializationProxy()
        {
            // Empty constructor for Externalizable class
        }

        protected ImmutableFloatBooleanMapSerializationProxy(FloatBooleanMap map)
        {
            this.map = map;
        }

        public void writeExternal(final ObjectOutput out) throws IOException
        {
            out.writeInt(this.map.size());
            try
            {
                this.map.forEachKeyValue(new CheckedFloatBooleanProcedure()
                {
                    @Override
                    public void safeValue(float key, boolean value) throws IOException
                    {
                        out.writeFloat(key);
                        out.writeBoolean(value);
                    }
                });
            }
            catch (RuntimeException e)
            {
                if (e.getCause() instanceof IOException)
                {
                    throw (IOException) e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
        {
            int size = in.readInt();
            MutableFloatBooleanMap deserializedMap = new FloatBooleanHashMap();

            for (int i = 0; i < size; i++)
            {
                deserializedMap.put(in.readFloat(), in.readBoolean());
            }

            this.map = deserializedMap;
        }

        protected Object readResolve()
        {
            return this.map.toImmutable();
        }
    }
}
