/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

import com.gs.collections.api.ByteIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyByteIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableByteBag;
import com.gs.collections.api.block.function.primitive.ByteToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectByteToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BytePredicate;
import com.gs.collections.api.block.predicate.primitive.FloatBytePredicate;
import com.gs.collections.api.block.procedure.primitive.ByteProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatByteProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.MutableByteCollection;
import com.gs.collections.api.iterator.ByteIterator;
import com.gs.collections.api.list.primitive.MutableByteList;
import com.gs.collections.api.map.primitive.FloatByteMap;
import com.gs.collections.api.map.primitive.ImmutableFloatByteMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableByteSet;
import com.gs.collections.impl.bag.mutable.primitive.ByteHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.ByteLists;
import com.gs.collections.impl.lazy.primitive.LazyByteIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.ByteArrayList;
import com.gs.collections.impl.map.mutable.primitive.FloatByteHashMap;
import com.gs.collections.impl.set.mutable.primitive.ByteHashSet;

/**
 * ImmutableFloatByteEmptyMap is an optimization for {@link ImmutableFloatByteMap} of size 0.
 * This file was automatically generated from template file immutablePrimitivePrimitiveEmptyMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableFloatByteEmptyMap implements ImmutableFloatByteMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final byte EMPTY_VALUE = (byte) 0;
    static final ImmutableFloatByteMap INSTANCE = new ImmutableFloatByteEmptyMap();

    private Object readResolve()
    {
        return INSTANCE;
    }

    public byte get(float key)
    {
        return EMPTY_VALUE;
    }

    public byte getIfAbsent(float key, byte ifAbsent)
    {
        return ifAbsent;
    }

    public byte getOrThrow(float key)
    {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key)
    {
        return false;
    }

    public boolean containsValue(byte value)
    {
        return false;
    }

    public void forEachValue(ByteProcedure procedure)
    {
    }

    public void forEachKey(FloatProcedure procedure)
    {
    }

    public void forEachKeyValue(FloatByteProcedure procedure)
    {
    }

    public LazyFloatIterable keysView()
    {
        return new FloatByteHashMap(0).keysView();
    }

    public ImmutableFloatByteMap select(FloatBytePredicate predicate)
    {
        return this;
    }

    public ImmutableFloatByteMap reject(FloatBytePredicate predicate)
    {
        return this;
    }

    public ImmutableFloatByteMap toImmutable()
    {
        return this;
    }

    public ByteIterator byteIterator()
    {
        return new InternalByteIterator();
    }

    private static class InternalByteIterator implements ByteIterator
    {
        public boolean hasNext()
        {
            return false;
        }

        public byte next()
        {
            throw new NoSuchElementException();
        }
    }

    public void forEach(ByteProcedure procedure)
    {
    }

    public int count(BytePredicate predicate)
    {
        return 0;
    }

    public long sum()
    {
        return 0L;
    }

    public byte min()
    {
        throw new NoSuchElementException();
    }

    public byte max()
    {
        throw new NoSuchElementException();
    }

    public byte maxIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public byte minIfEmpty(byte defaultValue)
    {
        return defaultValue;
    }

    public double average()
    {
        throw new ArithmeticException();
    }

    public double median()
    {
        throw new ArithmeticException();
    }

    public byte[] toSortedArray()
    {
        return new byte[0];
    }

    public MutableByteList toSortedList()
    {
        return new ByteArrayList();
    }

    public boolean anySatisfy(BytePredicate predicate)
    {
        return false;
    }

    public boolean allSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public boolean noneSatisfy(BytePredicate predicate)
    {
        return true;
    }

    public ImmutableByteCollection select(BytePredicate predicate)
    {
        return ByteLists.immutable.with();
    }

    public ImmutableByteCollection reject(BytePredicate predicate)
    {
        return ByteLists.immutable.with();
    }

    public byte detectIfNone(BytePredicate predicate, byte ifNone)
    {
        return ifNone;
    }

    public <V> ImmutableCollection<V> collect(ByteToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of();
    }

    public <T> T injectInto(T injectedValue, ObjectByteToObjectFunction<? super T, ? extends T> function)
    {
        return injectedValue;
    }

    public byte[] toArray()
    {
        return new byte[0];
    }

    public boolean contains(byte value)
    {
        return false;
    }

    public boolean containsAll(byte... source)
    {
        return source.length == 0;
    }

    public boolean containsAll(ByteIterable source)
    {
        return source.isEmpty();
    }

    public MutableByteList toList()
    {
        return new ByteArrayList();
    }

    public MutableByteSet toSet()
    {
        return new ByteHashSet();
    }

    public MutableByteBag toBag()
    {
        return new ByteHashBag();
    }

    public LazyByteIterable asLazy()
    {
        return new LazyByteIterableAdapter(this);
    }

    public ImmutableFloatByteMap newWithKeyValue(float key, byte value)
    {
        return new ImmutableFloatByteSingletonMap(key, value);
    }

    public ImmutableFloatByteMap newWithoutKey(float key)
    {
        return this;
    }

    public ImmutableFloatByteMap newWithoutAllKeys(FloatIterable keys)
    {
        return this;
    }

    public int size()
    {
        return 0;
    }

    public boolean isEmpty()
    {
        return true;
    }

    public boolean notEmpty()
    {
        return false;
    }

    public MutableFloatSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableByteCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof FloatByteMap))
        {
            return false;
        }
        FloatByteMap map = (FloatByteMap) obj;
        return map.isEmpty();
    }

    @Override
    public int hashCode()
    {
        return 0;
    }

    @Override
    public String toString()
    {
        return "{}";
    }

    public String makeString()
    {
        return "";
    }

    public String makeString(String separator)
    {
        return "";
    }

    public String makeString(String start, String separator, String end)
    {
        return start + end;
    }

    public void appendString(Appendable appendable)
    {
    }

    public void appendString(Appendable appendable, String separator)
    {
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
