/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyCharIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.bag.primitive.MutableCharBag;
import com.gs.collections.api.block.function.primitive.CharToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.CharPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatCharPredicate;
import com.gs.collections.api.block.procedure.primitive.CharProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatCharProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.MutableCharCollection;
import com.gs.collections.api.iterator.CharIterator;
import com.gs.collections.api.list.primitive.MutableCharList;
import com.gs.collections.api.map.primitive.FloatCharMap;
import com.gs.collections.api.map.primitive.ImmutableFloatCharMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableCharSet;
import com.gs.collections.impl.bag.mutable.primitive.CharHashBag;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.primitive.FloatCharMaps;
import com.gs.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.CharArrayList;
import com.gs.collections.impl.map.mutable.primitive.FloatCharHashMap;
import com.gs.collections.impl.set.mutable.primitive.CharHashSet;

/**
 * ImmutableFloatCharSingletonMap is an optimization for {@link ImmutableFloatCharMap} of size 1.
 * This file was automatically generated from template file immutablePrimitivePrimitiveSingletonMap.stg.
 * @since 4.0.
 */
final class ImmutableFloatCharSingletonMap implements ImmutableFloatCharMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private static final char EMPTY_VALUE = '\0';
    private final float key1;
    private final char value1;

    ImmutableFloatCharSingletonMap(float key1, char value1)
    {
        this.key1 = key1;
        this.value1 = value1;
    }

    public char get(float key)
    {
        return this.getIfAbsent(key, EMPTY_VALUE);
    }

    public char getIfAbsent(float key, char ifAbsent)
    {
        return Float.compare(this.key1, key) == 0 ? this.value1 : ifAbsent;
    }

    public char getOrThrow(float key)
    {
        if (Float.compare(this.key1, key) == 0)
        {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(float key)
    {
        return Float.compare(this.key1, key) == 0;
    }

    public boolean containsValue(char value)
    {
        return this.value1 == value;
    }

    public void forEachValue(CharProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public void forEachKey(FloatProcedure procedure)
    {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(FloatCharProcedure procedure)
    {
        procedure.value(this.key1, this.value1);
    }

    public LazyFloatIterable keysView()
    {
        return FloatCharHashMap.newWithKeysValues(this.key1, this.value1).keysView();
    }

    public ImmutableFloatCharMap select(FloatCharPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? FloatCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable()
                : new FloatCharHashMap().toImmutable();
    }

    public ImmutableFloatCharMap reject(FloatCharPredicate predicate)
    {
        return predicate.accept(this.key1, this.value1) ? new FloatCharHashMap().toImmutable()
                : FloatCharHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function)
    {
        return function.valueOf(injectedValue, this.value1);
    }

    public ImmutableFloatCharMap toImmutable()
    {
        return this;
    }

    public CharIterator charIterator()
    {
        return FloatCharHashMap.newWithKeysValues(this.key1, this.value1).charIterator();
    }

    public void forEach(CharProcedure procedure)
    {
        procedure.value(this.value1);
    }

    public int count(CharPredicate predicate)
    {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum()
    {
        return this.value1;
    }

    public char min()
    {
        return this.value1;
    }

    public char max()
    {
        return this.value1;
    }

    public char maxIfEmpty(char defaultValue)
    {
        return this.value1;
    }

    public char minIfEmpty(char defaultValue)
    {
        return this.value1;
    }

    public double average()
    {
        return this.value1;
    }

    public double median()
    {
        return this.value1;
    }

    public char[] toSortedArray()
    {
        return new char[]{this.value1};
    }

    public MutableCharList toSortedList()
    {
        return CharArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(CharPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(CharPredicate predicate)
    {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(CharPredicate predicate)
    {
        return !predicate.accept(this.value1);
    }

    public ImmutableCharCollection select(CharPredicate predicate)
    {
        return predicate.accept(this.value1) ? CharArrayList.newListWith(this.value1).toImmutable() : new CharArrayList().toImmutable();
    }

    public ImmutableCharCollection reject(CharPredicate predicate)
    {
        return predicate.accept(this.value1) ? new CharArrayList().toImmutable() : CharArrayList.newListWith(this.value1).toImmutable();
    }

    public char detectIfNone(CharPredicate predicate, char ifNone)
    {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public <V> ImmutableCollection<V> collect(CharToObjectFunction<? extends V> function)
    {
        return Lists.immutable.of(function.valueOf(this.value1));
    }

    public char[] toArray()
    {
        return new char[]{this.value1};
    }

    public boolean contains(char value)
    {
        return this.value1 == value;
    }

    public boolean containsAll(char... source)
    {
        for (char value : source)
        {
            if (this.value1 != value)
            {
                return false;
            }
        }
        return true;
    }

    public boolean containsAll(CharIterable source)
    {
        for (CharIterator iterator = source.charIterator(); iterator.hasNext(); )
        {
            if (this.value1 != iterator.next())
            {
                return false;
            }
        }
        return true;
    }

    public MutableCharList toList()
    {
        return CharArrayList.newListWith(this.value1);
    }

    public MutableCharSet toSet()
    {
        return CharHashSet.newSetWith(this.value1);
    }

    public MutableCharBag toBag()
    {
        return CharHashBag.newBagWith(this.value1);
    }

    public LazyCharIterable asLazy()
    {
        return new LazyCharIterableAdapter(this);
    }

    public ImmutableFloatCharMap newWithKeyValue(float key, char value)
    {
        return FloatCharMaps.immutable.withAll(FloatCharHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableFloatCharMap newWithoutKey(float key)
    {
        return Float.compare(this.key1, key) == 0 ? FloatCharMaps.immutable.with() : this;
    }

    public ImmutableFloatCharMap newWithoutAllKeys(FloatIterable keys)
    {
        return keys.contains(this.key1) ? FloatCharMaps.immutable.with() : this;
    }

    public int size()
    {
        return 1;
    }

    public boolean isEmpty()
    {
        return false;
    }

    public boolean notEmpty()
    {
        return true;
    }

    public MutableFloatSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableCharCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == this)
        {
            return true;
        }
        if (!(obj instanceof FloatCharMap))
        {
            return false;
        }
        FloatCharMap map = (FloatCharMap) obj;
        if (map.size() != 1)
        {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    @Override
    public int hashCode()
    {
        return Float.floatToIntBits(this.key1) ^ (int) this.value1;
    }

    @Override
    public String toString()
    {
        return this.makeString("{", ", ", "}");
    }

    public String makeString()
    {
        return this.makeString(", ");
    }

    public String makeString(String separator)
    {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end)
    {
        Appendable stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return stringBuilder.toString();
    }

    public void appendString(Appendable appendable)
    {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        try
        {
            appendable.append(start);
            appendable.append(String.valueOf(this.key1));
            appendable.append("=");
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e)
        {
            throw new RuntimeException(e);
        }
    }
}
