/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableFloatLongMapFactory;
import com.gs.collections.api.map.primitive.ImmutableFloatLongMap;
import com.gs.collections.api.map.primitive.FloatLongMap;

/**
 * ImmutableFloatLongMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableFloatLongMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableFloatLongMapFactoryImpl implements ImmutableFloatLongMapFactory
{
    public ImmutableFloatLongMap of()
    {
        return this.with();
    }

    public ImmutableFloatLongMap with()
    {
        return ImmutableFloatLongEmptyMap.INSTANCE;
    }

    public ImmutableFloatLongMap of(float key, long value)
    {
        return this.with(key, value);
    }

    public ImmutableFloatLongMap with(float key, long value)
    {
        return new ImmutableFloatLongSingletonMap(key, value);
    }

    public ImmutableFloatLongMap ofAll(FloatLongMap map)
    {
        return this.withAll(map);
    }

    public ImmutableFloatLongMap withAll(FloatLongMap map)
    {
        if (map instanceof ImmutableFloatLongMap)
        {
            return (ImmutableFloatLongMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            float key = map.keysView().floatIterator().next();
            return new ImmutableFloatLongSingletonMap(key, map.get(key));
        }
        return new ImmutableFloatLongHashMap(map);
    }
}
