/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.ByteFunction;
import com.gs.collections.api.block.function.primitive.CharFunction;
import com.gs.collections.api.block.function.primitive.DoubleFunction;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.predicate.primitive.FloatObjectPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.FloatObjectProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableBooleanCollection;
import com.gs.collections.api.collection.primitive.ImmutableByteCollection;
import com.gs.collections.api.collection.primitive.ImmutableCharCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.ImmutableIntCollection;
import com.gs.collections.api.collection.primitive.ImmutableLongCollection;
import com.gs.collections.api.collection.primitive.ImmutableShortCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.list.MutableList;
import com.gs.collections.api.map.MapIterable;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.map.primitive.FloatObjectMap;
import com.gs.collections.api.map.primitive.ImmutableFloatObjectMap;
import com.gs.collections.api.map.primitive.MutableFloatObjectMap;
import com.gs.collections.api.map.sorted.MutableSortedMap;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.MutableMultimap;
import com.gs.collections.api.partition.PartitionIterable;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.sorted.MutableSortedSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.UnmodifiableIteratorAdapter;
import com.gs.collections.impl.map.mutable.primitive.FloatObjectHashMap;

/**
 * ImmutableFloatObjectHashMap is the non-modifiable equivalent of {@link FloatObjectHashMap}.
 * This file was automatically generated from template file immutablePrimitiveObjectHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableFloatObjectHashMap<V> extends AbstractImmutableFloatObjectMap<V> implements Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableFloatObjectMap<V> delegate;

    ImmutableFloatObjectHashMap(FloatObjectMap<? extends V> delegate)
    {
        this.delegate = new FloatObjectHashMap<V>(delegate);
    }

    public V get(float key)
    {
        return this.delegate.get(key);
    }

    public V getIfAbsent(float key, Function0<? extends V> ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(float key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(Object value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(Procedure<? super V> procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatObjectProcedure<? super V> procedure)
    {
        this.delegate.forEachKeyValue(procedure);
    }

    public ImmutableFloatObjectMap<V> select(FloatObjectPredicate<? super V> predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableFloatObjectMap<V> reject(FloatObjectPredicate<? super V> predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public ImmutableFloatObjectMap<V> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public V getFirst()
    {
        return this.delegate.getFirst();
    }

    public V getLast()
    {
        return this.delegate.getLast();
    }

    public boolean contains(Object object)
    {
        return this.delegate.contains(object);
    }

    public boolean containsAllIterable(Iterable<?> source)
    {
        return this.delegate.containsAllIterable(source);
    }

    public boolean containsAll(Collection<?> source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAllArguments(Object... elements)
    {
        return this.delegate.containsAllArguments(elements);
    }

    public ImmutableCollection<V> select(Predicate<? super V> predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target)
    {
        return this.delegate.select(predicate, target);
    }

    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection)
    {
        return this.delegate.selectWith(predicate, parameter, targetCollection);
    }

    public ImmutableCollection<V> reject(Predicate<? super V> predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target)
    {
        return this.delegate.reject(predicate, target);
    }

    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection)
    {
        return this.delegate.rejectWith(predicate, parameter, targetCollection);
    }

    public PartitionIterable<V> partition(Predicate<? super V> predicate)
    {
        return this.delegate.partition(predicate);
    }

    public <S> RichIterable<S> selectInstancesOf(Class<S> clazz)
    {
        return this.delegate.selectInstancesOf(clazz);
    }

    public <V1> ImmutableCollection<V1> collect(Function<? super V, ? extends V1> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public ImmutableBooleanCollection collectBoolean(BooleanFunction<? super V> booleanFunction)
    {
        return this.delegate.collectBoolean(booleanFunction).toImmutable();
    }

    public ImmutableByteCollection collectByte(ByteFunction<? super V> byteFunction)
    {
        return this.delegate.collectByte(byteFunction).toImmutable();
    }

    public ImmutableCharCollection collectChar(CharFunction<? super V> charFunction)
    {
        return this.delegate.collectChar(charFunction).toImmutable();
    }

    public ImmutableDoubleCollection collectDouble(DoubleFunction<? super V> doubleFunction)
    {
        return this.delegate.collectDouble(doubleFunction).toImmutable();
    }

    public ImmutableFloatCollection collectFloat(FloatFunction<? super V> floatFunction)
    {
        return this.delegate.collectFloat(floatFunction).toImmutable();
    }

    public ImmutableIntCollection collectInt(IntFunction<? super V> intFunction)
    {
        return this.delegate.collectInt(intFunction).toImmutable();
    }

    public ImmutableLongCollection collectLong(LongFunction<? super V> longFunction)
    {
        return this.delegate.collectLong(longFunction).toImmutable();
    }

    public ImmutableShortCollection collectShort(ShortFunction<? super V> shortFunction)
    {
        return this.delegate.collectShort(shortFunction).toImmutable();
    }

    public <V1> RichIterable<V1> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function)
    {
        return this.delegate.collectIf(predicate, function);
    }

    public <V1> RichIterable<V1> flatCollect(Function<? super V, ? extends Iterable<V1>> function)
    {
        return this.delegate.flatCollect(function);
    }

    public V detect(Predicate<? super V> predicate)
    {
        return this.delegate.detect(predicate);
    }

    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function)
    {
        return this.delegate.detectIfNone(predicate, function);
    }

    public int count(Predicate<? super V> predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(Predicate<? super V> predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(Predicate<? super V> predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(Predicate<? super V> predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function)
    {
        return this.delegate.injectInto(injectedValue, function);
    }

    public MutableList<V> toList()
    {
        return this.delegate.toList();
    }

    public MutableList<V> toSortedList()
    {
        return this.delegate.toSortedList();
    }

    public MutableList<V> toSortedList(Comparator<? super V> comparator)
    {
        return this.delegate.toSortedList(comparator);
    }

    public MutableSet<V> toSet()
    {
        return this.delegate.toSet();
    }

    public MutableSortedSet<V> toSortedSet()
    {
        return this.delegate.toSortedSet();
    }

    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator)
    {
        return this.delegate.toSortedSet(comparator);
    }

    public MutableBag<V> toBag()
    {
        return this.delegate.toBag();
    }

    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction)
    {
        return this.delegate.toMap(keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction)
    {
        return this.delegate.toSortedMap(keyFunction, valueFunction);
    }

    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction)
    {
        return this.delegate.toSortedMap(comparator, keyFunction, valueFunction);
    }

    public LazyIterable<V> asLazy()
    {
        return this.delegate.asLazy();
    }

    public Object[] toArray()
    {
        return this.delegate.toArray();
    }

    public <T> T[] toArray(T[] a)
    {
        return this.delegate.toArray(a);
    }

    public V min(Comparator<? super V> comparator)
    {
        return this.delegate.min(comparator);
    }

    public V max(Comparator<? super V> comparator)
    {
        return this.delegate.max(comparator);
    }

    public V min()
    {
        return this.delegate.min();
    }

    public V max()
    {
        return this.delegate.max();
    }

    public long sumOfInt(IntFunction<? super V> function)
    {
        return this.delegate.sumOfInt(function);
    }

    public double sumOfFloat(FloatFunction<? super V> function)
    {
        return this.delegate.sumOfFloat(function);
    }

    public long sumOfLong(LongFunction<? super V> function)
    {
        return this.delegate.sumOfLong(function);
    }

    public double sumOfDouble(DoubleFunction<? super V> function)
    {
        return this.delegate.sumOfDouble(function);
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    public <V1> Multimap<V1, V> groupBy(Function<? super V, ? extends V1> function)
    {
        return this.delegate.groupBy(function);
    }

    public <V1> Multimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function)
    {
        return this.delegate.groupByEach(function);
    }

    public <S> RichIterable<Pair<V, S>> zip(Iterable<S> that)
    {
        return this.delegate.zip(that);
    }

    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target)
    {
        return this.delegate.zip(that, target);
    }

    public RichIterable<Pair<V, Integer>> zipWithIndex()
    {
        return this.delegate.zipWithIndex();
    }

    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target)
    {
        return this.delegate.zipWithIndex(target);
    }

    public RichIterable<RichIterable<V>> chunk(int size)
    {
        return this.delegate.chunk(size);
    }

    public <K, V1> MapIterable<K, V1> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Procedure2<? super V1, ? super V> mutatingAggregator)
    {
        return this.delegate.aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
    }

    public <K, V1> MapIterable<K, V1> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends V1> zeroValueFactory, Function2<? super V1, ? super V, ? extends V1> nonMutatingAggregator)
    {
        return this.delegate.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
    }

    public <V1, R extends MutableMultimap<V1, V>> R groupByEach(Function<? super V, ? extends Iterable<V1>> function, R target)
    {
        return this.delegate.groupByEach(function, target);
    }

    public <V1, R extends MutableMultimap<V1, V>> R groupBy(Function<? super V, ? extends V1> function, R target)
    {
        return this.delegate.groupBy(function, target);
    }

    public <V1 extends Comparable<? super V1>> V maxBy(Function<? super V, ? extends V1> function)
    {
        return this.delegate.maxBy(function);
    }

    public <V1 extends Comparable<? super V1>> V minBy(Function<? super V, ? extends V1> function)
    {
        return this.delegate.minBy(function);
    }

    public <V1 extends Comparable<? super V1>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends V1> function)
    {
        return this.delegate.toSortedSetBy(function);
    }

    public <V1 extends Comparable<? super V1>> MutableList<V> toSortedListBy(Function<? super V, ? extends V1> function)
    {
        return this.delegate.toSortedListBy(function);
    }

    public <V1, R extends Collection<V1>> R flatCollect(Function<? super V, ? extends Iterable<V1>> function, R target)
    {
        return this.delegate.flatCollect(function, target);
    }

    public <V1, R extends Collection<V1>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function, R target)
    {
        return this.delegate.collectIf(predicate, function, target);
    }

    public <P, V1, R extends Collection<V1>> R collectWith(Function2<? super V, ? super P, ? extends V1> function, P parameter, R targetCollection)
    {
        return this.delegate.collectWith(function, parameter, targetCollection);
    }

    public <V1, R extends Collection<V1>> R collect(Function<? super V, ? extends V1> function, R target)
    {
        return this.delegate.collect(function, target);
    }

    public ImmutableFloatObjectMap<V> newWithKeyValue(float key, V value)
    {
        FloatObjectHashMap<V> map = new FloatObjectHashMap<V>(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableFloatObjectMap<V> newWithoutKey(float key)
    {
        FloatObjectHashMap<V> map = new FloatObjectHashMap<V>(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableFloatObjectMap<V> newWithoutAllKeys(FloatIterable keys)
    {
        FloatObjectHashMap<V> map = new FloatObjectHashMap<V>(this);
        FloatIterator iterator = keys.floatIterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public void forEach(Procedure<? super V> procedure)
    {
        this.delegate.forEach(procedure);
    }

    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure)
    {
        this.delegate.forEachWithIndex(objectIntProcedure);
    }

    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter)
    {
        this.delegate.forEachWith(procedure, parameter);
    }

    public Iterator<V> iterator()
    {
        return new UnmodifiableIteratorAdapter<V>(this.delegate.iterator());
    }

    public MutableFloatSet keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public Collection<V> values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    private Object writeReplace()
    {
        return new ImmutableFloatObjectMapSerializationProxy<V>(this);
    }
}
