/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableIntDoubleMapFactory;
import com.gs.collections.api.map.primitive.ImmutableIntDoubleMap;
import com.gs.collections.api.map.primitive.IntDoubleMap;

/**
 * ImmutableIntDoubleMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntDoubleMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntDoubleMapFactoryImpl implements ImmutableIntDoubleMapFactory
{
    public ImmutableIntDoubleMap of()
    {
        return this.with();
    }

    public ImmutableIntDoubleMap with()
    {
        return ImmutableIntDoubleEmptyMap.INSTANCE;
    }

    public ImmutableIntDoubleMap of(int key, double value)
    {
        return this.with(key, value);
    }

    public ImmutableIntDoubleMap with(int key, double value)
    {
        return new ImmutableIntDoubleSingletonMap(key, value);
    }

    public ImmutableIntDoubleMap ofAll(IntDoubleMap map)
    {
        return this.withAll(map);
    }

    public ImmutableIntDoubleMap withAll(IntDoubleMap map)
    {
        if (map instanceof ImmutableIntDoubleMap)
        {
            return (ImmutableIntDoubleMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            int key = map.keysView().intIterator().next();
            return new ImmutableIntDoubleSingletonMap(key, map.get(key));
        }
        return new ImmutableIntDoubleHashMap(map);
    }
}
