/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableIntShortMapFactory;
import com.gs.collections.api.map.primitive.ImmutableIntShortMap;
import com.gs.collections.api.map.primitive.IntShortMap;

/**
 * ImmutableIntShortMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableIntShortMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableIntShortMapFactoryImpl implements ImmutableIntShortMapFactory
{
    public ImmutableIntShortMap of()
    {
        return this.with();
    }

    public ImmutableIntShortMap with()
    {
        return ImmutableIntShortEmptyMap.INSTANCE;
    }

    public ImmutableIntShortMap of(int key, short value)
    {
        return this.with(key, value);
    }

    public ImmutableIntShortMap with(int key, short value)
    {
        return new ImmutableIntShortSingletonMap(key, value);
    }

    public ImmutableIntShortMap ofAll(IntShortMap map)
    {
        return this.withAll(map);
    }

    public ImmutableIntShortMap withAll(IntShortMap map)
    {
        if (map instanceof ImmutableIntShortMap)
        {
            return (ImmutableIntShortMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            int key = map.keysView().intIterator().next();
            return new ImmutableIntShortSingletonMap(key, map.get(key));
        }
        return new ImmutableIntShortHashMap(map);
    }
}
