/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableLongBooleanMapFactory;
import com.gs.collections.api.map.primitive.ImmutableLongBooleanMap;
import com.gs.collections.api.map.primitive.LongBooleanMap;

/**
 * ImmutableLongBooleanMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongBooleanMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongBooleanMapFactoryImpl implements ImmutableLongBooleanMapFactory
{
    public ImmutableLongBooleanMap of()
    {
        return this.with();
    }

    public ImmutableLongBooleanMap with()
    {
        return ImmutableLongBooleanEmptyMap.INSTANCE;
    }

    public ImmutableLongBooleanMap of(long key, boolean value)
    {
        return this.with(key, value);
    }

    public ImmutableLongBooleanMap with(long key, boolean value)
    {
        return new ImmutableLongBooleanSingletonMap(key, value);
    }

    public ImmutableLongBooleanMap ofAll(LongBooleanMap map)
    {
        return this.withAll(map);
    }

    public ImmutableLongBooleanMap withAll(LongBooleanMap map)
    {
        if (map instanceof ImmutableLongBooleanMap)
        {
            return (ImmutableLongBooleanMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            long key = map.keysView().longIterator().next();
            return new ImmutableLongBooleanSingletonMap(key, map.get(key));
        }
        return new ImmutableLongBooleanHashMap(map);
    }
}
