/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableLongDoubleMapFactory;
import com.gs.collections.api.map.primitive.ImmutableLongDoubleMap;
import com.gs.collections.api.map.primitive.LongDoubleMap;

/**
 * ImmutableLongDoubleMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongDoubleMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongDoubleMapFactoryImpl implements ImmutableLongDoubleMapFactory
{
    public ImmutableLongDoubleMap of()
    {
        return this.with();
    }

    public ImmutableLongDoubleMap with()
    {
        return ImmutableLongDoubleEmptyMap.INSTANCE;
    }

    public ImmutableLongDoubleMap of(long key, double value)
    {
        return this.with(key, value);
    }

    public ImmutableLongDoubleMap with(long key, double value)
    {
        return new ImmutableLongDoubleSingletonMap(key, value);
    }

    public ImmutableLongDoubleMap ofAll(LongDoubleMap map)
    {
        return this.withAll(map);
    }

    public ImmutableLongDoubleMap withAll(LongDoubleMap map)
    {
        if (map instanceof ImmutableLongDoubleMap)
        {
            return (ImmutableLongDoubleMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            long key = map.keysView().longIterator().next();
            return new ImmutableLongDoubleSingletonMap(key, map.get(key));
        }
        return new ImmutableLongDoubleHashMap(map);
    }
}
