/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import com.gs.collections.api.factory.map.primitive.ImmutableLongFloatMapFactory;
import com.gs.collections.api.map.primitive.ImmutableLongFloatMap;
import com.gs.collections.api.map.primitive.LongFloatMap;

/**
 * ImmutableLongFloatMapFactoryImpl is a factory implementation which creates instances of type {@link ImmutableLongFloatMap}.
 * This file was automatically generated from template file immutablePrimitivePrimitiveMapFactoryImpl.stg.
 *
 * @since 4.0.
 */
public class ImmutableLongFloatMapFactoryImpl implements ImmutableLongFloatMapFactory
{
    public ImmutableLongFloatMap of()
    {
        return this.with();
    }

    public ImmutableLongFloatMap with()
    {
        return ImmutableLongFloatEmptyMap.INSTANCE;
    }

    public ImmutableLongFloatMap of(long key, float value)
    {
        return this.with(key, value);
    }

    public ImmutableLongFloatMap with(long key, float value)
    {
        return new ImmutableLongFloatSingletonMap(key, value);
    }

    public ImmutableLongFloatMap ofAll(LongFloatMap map)
    {
        return this.withAll(map);
    }

    public ImmutableLongFloatMap withAll(LongFloatMap map)
    {
        if (map instanceof ImmutableLongFloatMap)
        {
            return (ImmutableLongFloatMap) map;
        }
        if (map.isEmpty())
        {
            return this.with();
        }
        if (map.size() == 1)
        {
            long key = map.keysView().longIterator().next();
            return new ImmutableLongFloatSingletonMap(key, map.get(key));
        }
        return new ImmutableLongFloatHashMap(map);
    }
}
