/*
 * Copyright 2013 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.immutable.primitive;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Set;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.bag.primitive.MutableDoubleBag;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.api.block.predicate.primitive.ObjectDoublePredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.primitive.DoubleProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectDoubleProcedure;
import com.gs.collections.api.map.primitive.ObjectDoubleMap;
import com.gs.collections.api.collection.ImmutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableDoubleCollection;
import com.gs.collections.api.collection.primitive.MutableDoubleCollection;
import com.gs.collections.api.iterator.DoubleIterator;
import com.gs.collections.api.list.primitive.MutableDoubleList;
import com.gs.collections.api.map.primitive.ImmutableObjectDoubleMap;
import com.gs.collections.api.map.primitive.MutableObjectDoubleMap;
import com.gs.collections.api.set.primitive.MutableDoubleSet;
import com.gs.collections.impl.map.mutable.primitive.ObjectDoubleHashMap;

/**
 * ImmutableObjectDoubleHashMap is the non-modifiable equivalent of {@link ObjectDoubleHashMap}.
 * This file was automatically generated from template file immutableObjectPrimitiveHashMap.stg.
 *
 * @since 4.0.
 */
final class ImmutableObjectDoubleHashMap<K> extends AbstractImmutableObjectDoubleMap<K> implements Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableObjectDoubleMap<K> delegate;

    ImmutableObjectDoubleHashMap(ObjectDoubleMap<? extends K> delegate)
    {
        this.delegate = new ObjectDoubleHashMap<K>(delegate);
    }

    public DoubleIterator doubleIterator()
    {
        return this.delegate.doubleIterator();
    }

    public void forEach(DoubleProcedure procedure)
    {
        this.delegate.forEach(procedure);
    }

    public int count(DoublePredicate predicate)
    {
        return this.delegate.count(predicate);
    }

    public boolean anySatisfy(DoublePredicate predicate)
    {
        return this.delegate.anySatisfy(predicate);
    }

    public boolean allSatisfy(DoublePredicate predicate)
    {
        return this.delegate.allSatisfy(predicate);
    }

    public boolean noneSatisfy(DoublePredicate predicate)
    {
        return this.delegate.noneSatisfy(predicate);
    }

    public ImmutableDoubleCollection select(DoublePredicate predicate)
    {
        return this.delegate.select(predicate).toImmutable();
    }

    public ImmutableDoubleCollection reject(DoublePredicate predicate)
    {
        return this.delegate.reject(predicate).toImmutable();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone)
    {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function)
    {
        return ((ObjectDoubleHashMap<T>) this.delegate).injectInto(injectedValue, function);
    }

    public <V> ImmutableCollection<V> collect(DoubleToObjectFunction<? extends V> function)
    {
        return this.delegate.collect(function).toImmutable();
    }

    public double sum()
    {
        return this.delegate.sum();
    }

    public double max()
    {
        return this.delegate.max();
    }

    public double maxIfEmpty(double defaultValue)
    {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    public double min()
    {
        return this.delegate.min();
    }

    public double minIfEmpty(double defaultValue)
    {
        return this.delegate.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.delegate.average();
    }

    public double median()
    {
        return this.delegate.median();
    }

    public double[] toSortedArray()
    {
        return this.delegate.toSortedArray();
    }


    public MutableDoubleList toSortedList()
    {
        return this.delegate.toSortedList();
    }


    public double[] toArray()
    {
        return this.delegate.toArray();
    }

    public boolean contains(double value)
    {
        return this.delegate.contains(value);
    }

    public boolean containsAll(double... source)
    {
        return this.delegate.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source)
    {
        return this.delegate.containsAll(source);
    }

    public MutableDoubleList toList()
    {
        return this.delegate.toList();
    }

    public MutableDoubleSet toSet()
    {
        return this.delegate.toSet();
    }

    public MutableDoubleBag toBag()
    {
        return this.delegate.toBag();
    }

    public LazyDoubleIterable asLazy()
    {
        return this.delegate.asLazy();
    }

    public ImmutableObjectDoubleMap<K> newWithKeyValue(K key, double value)
    {
        ObjectDoubleHashMap<K> map = ObjectDoubleHashMap.newMap();
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    public ImmutableObjectDoubleMap<K> newWithoutKey(K key)
    {
        ObjectDoubleHashMap<K> map = ObjectDoubleHashMap.newMap();
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    public ImmutableObjectDoubleMap<K> newWithoutAllKeys(Iterable<? extends K> keys)
    {
        ObjectDoubleHashMap<K> map = ObjectDoubleHashMap.newMap();
        map.putAll(this);
        Iterator<? extends K> iterator = keys.iterator();
        while (iterator.hasNext())
        {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    public double get(Object key)
    {
        return this.delegate.get(key);
    }

    public double getOrThrow(Object key)
    {
        return this.delegate.getOrThrow(key);
    }

    public double getIfAbsent(Object key, double ifAbsent)
    {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    public boolean containsKey(Object key)
    {
        return this.delegate.containsKey(key);
    }

    public boolean containsValue(double value)
    {
        return this.delegate.containsValue(value);
    }

    public void forEachValue(DoubleProcedure procedure)
    {
        this.delegate.forEachValue(procedure);
    }

    public void forEachKey(Procedure<? super K> procedure)
    {
        this.delegate.forEachKey(procedure);
    }

    public void forEachKeyValue(ObjectDoubleProcedure<? super K> objectDoubleProcedure)
    {
        this.delegate.forEachKeyValue(objectDoubleProcedure);
    }

    public ImmutableObjectDoubleMap<K> select(ObjectDoublePredicate<? super K> objectDoublePredicate)
    {
        return this.delegate.select(objectDoublePredicate).toImmutable();
    }

    public ImmutableObjectDoubleMap<K> reject(ObjectDoublePredicate<? super K> objectDoublePredicate)
    {
        return this.delegate.reject(objectDoublePredicate).toImmutable();
    }

    public ImmutableObjectDoubleMap<K> toImmutable()
    {
        return this;
    }

    public int size()
    {
        return this.delegate.size();
    }

    public boolean isEmpty()
    {
        return this.delegate.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.delegate.notEmpty();
    }

    public Set<K> keySet()
    {
        throw new UnsupportedOperationException("keySet is not implemented yet!");
    }

    public MutableDoubleCollection values()
    {
        throw new UnsupportedOperationException("values is not implemented yet!");
    }

    @Override
    public boolean equals(Object obj)
    {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public String toString()
    {
        return this.delegate.toString();
    }

    public String makeString()
    {
        return this.delegate.makeString();
    }

    public String makeString(String separator)
    {
        return this.delegate.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.delegate.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.delegate.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.delegate.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.delegate.appendString(appendable, start, separator, end);
    }

    private Object writeReplace()
    {
        return new ImmutableObjectDoubleMapSerializationProxy<K>(this);
    }
}
